/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int mVersionCode;
    private Boolean zzaIA;
    private Boolean zzaIB;
    private int zzaIC = -1;
    private CameraPosition zzaID;
    private Boolean zzaIE;
    private Boolean zzaIF;
    private Boolean zzaIG;
    private Boolean zzaIH;
    private Boolean zzaII;
    private Boolean zzaIJ;
    private Boolean zzaIK;
    private Boolean zzaIL;
    private Boolean zzaIM;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled, byte liteMode, byte mapToolbarEnabled, byte ambientEnabled) {
        this.mVersionCode = versionCode;
        this.zzaIA = com.google.android.gms.maps.internal.zza.zza(zOrderOnTop);
        this.zzaIB = com.google.android.gms.maps.internal.zza.zza(useViewLifecycleInFragment);
        this.zzaIC = mapType;
        this.zzaID = camera;
        this.zzaIE = com.google.android.gms.maps.internal.zza.zza(zoomControlsEnabled);
        this.zzaIF = com.google.android.gms.maps.internal.zza.zza(compassEnabled);
        this.zzaIG = com.google.android.gms.maps.internal.zza.zza(scrollGesturesEnabled);
        this.zzaIH = com.google.android.gms.maps.internal.zza.zza(zoomGesturesEnabled);
        this.zzaII = com.google.android.gms.maps.internal.zza.zza(tiltGesturesEnabled);
        this.zzaIJ = com.google.android.gms.maps.internal.zza.zza(rotateGesturesEnabled);
        this.zzaIK = com.google.android.gms.maps.internal.zza.zza(liteMode);
        this.zzaIL = com.google.android.gms.maps.internal.zza.zza(mapToolbarEnabled);
        this.zzaIM = com.google.android.gms.maps.internal.zza.zza(ambientEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzxz() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIA);
    }

    byte zzxA() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIB);
    }

    byte zzxB() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIE);
    }

    byte zzxC() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIF);
    }

    byte zzxD() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIG);
    }

    byte zzxE() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIH);
    }

    byte zzxF() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaII);
    }

    byte zzxG() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIJ);
    }

    byte zzxH() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIK);
    }

    byte zzxI() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIL);
    }

    byte zzxJ() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaIM);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.zzaIA = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.zzaIB = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.zzaIC = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.zzaID = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.zzaIE = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.zzaIF = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.zzaIG = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zzaIH = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.zzaII = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.zzaIJ = enabled;
        return this;
    }

    public GoogleMapOptions liteMode(boolean enabled) {
        this.zzaIK = enabled;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        this.zzaIL = enabled;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean enabled) {
        this.zzaIM = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzaIA;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzaIB;
    }

    public int getMapType() {
        return this.zzaIC;
    }

    public CameraPosition getCamera() {
        return this.zzaID;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzaIE;
    }

    public Boolean getCompassEnabled() {
        return this.zzaIF;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzaIG;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzaIH;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzaII;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzaIJ;
    }

    public Boolean getLiteMode() {
        return this.zzaIK;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzaIL;
    }

    public Boolean getAmbientEnabled() {
        return this.zzaIM;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

