/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zztz;
import com.google.android.gms.internal.measurement.zzvo;
import com.google.android.gms.internal.measurement.zzvs;
import com.google.android.gms.internal.measurement.zzxe;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzwh
extends zztz<Long>
implements zzvs<Long>,
zzxe,
RandomAccess {
    private static final zzwh zzcam = new zzwh();
    private long[] zzcan;
    private int size;

    zzwh() {
        this(new long[10], 0);
    }

    private zzwh(long[] lArray, int n) {
        this.zzcan = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zztx();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzcan, n2, this.zzcan, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzwh)) {
            return super.equals(object);
        }
        zzwh zzwh2 = (zzwh)object;
        if (this.size != zzwh2.size) {
            return false;
        }
        long[] lArray = zzwh2.zzcan;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzcan[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzvo.zzbf(this.zzcan[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzai(n);
        return this.zzcan[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbg(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zztx();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzcan.length) {
            System.arraycopy(this.zzcan, n, this.zzcan, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzcan, 0, lArray, 0, n);
            System.arraycopy(this.zzcan, n, lArray, n + 1, this.size - n);
            this.zzcan = lArray;
        }
        this.zzcan[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zztx();
        zzvo.checkNotNull(collection);
        if (!(collection instanceof zzwh)) {
            return super.addAll(collection);
        }
        zzwh zzwh2 = (zzwh)collection;
        if (zzwh2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzwh2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzwh2.size;
        if (n > this.zzcan.length) {
            this.zzcan = Arrays.copyOf(this.zzcan, n);
        }
        System.arraycopy(zzwh2.zzcan, 0, this.zzcan, this.size, zzwh2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zztx();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzcan[i])) continue;
            System.arraycopy(this.zzcan, i + 1, this.zzcan, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzwh zzwh2 = this;
        zzwh2.zztx();
        zzwh2.zzai(n);
        long l3 = zzwh2.zzcan[n];
        zzwh2.zzcan[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzwh zzwh2 = this;
        zzwh2.zztx();
        zzwh2.zzai(n);
        long l = zzwh2.zzcan[n];
        if (n < zzwh2.size - 1) {
            System.arraycopy(zzwh2.zzcan, n + 1, zzwh2.zzcan, n, zzwh2.size - n);
        }
        --zzwh2.size;
        ++zzwh2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzvs zzak(int n) {
        int n2 = n;
        zzwh zzwh2 = this;
        if (n2 < zzwh2.size) {
            throw new IllegalArgumentException();
        }
        return new zzwh(Arrays.copyOf(zzwh2.zzcan, n2), zzwh2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzcam.zzsm();
    }
}

