/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.UserHandle;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TargetApi(value=24)
public final class zzdx {
    private final JobScheduler zzadj;
    @Nullable
    private static final Method zzadk = zzdx.zzfu();
    @Nullable
    private static final Method zzadl = zzdx.zzfv();
    private static volatile zzdz zzadm = zzdy.zzadn;

    @Nullable
    private static Method zzfu() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return JobScheduler.class.getDeclaredMethod("scheduleAsPackage", JobInfo.class, String.class, Integer.TYPE, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No scheduleAsPackage method available, falling back to schedule");
                }
            }
        }
        return null;
    }

    @Nullable
    private static Method zzfv() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return UserHandle.class.getDeclaredMethod("myUserId", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No myUserId method available");
                }
            }
        }
        return null;
    }

    private static int zzfw() {
        block3: {
            if (zzadl != null) {
                try {
                    return (Integer)zzadl.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"myUserId invocation illegal", (Throwable)reflectiveOperationException);
                }
            }
        }
        return 0;
    }

    private zzdx(JobScheduler jobScheduler) {
        this.zzadj = jobScheduler;
    }

    private final int zza(JobInfo jobInfo, String string, int n, String string2) {
        if (zzadk != null) {
            try {
                return (Integer)zzadk.invoke((Object)this.zzadj, jobInfo, string, n, string2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                Log.e((String)string2, (String)"error calling scheduleAsPackage", (Throwable)reflectiveOperationException);
            }
        }
        return this.zzadj.schedule(jobInfo);
    }

    public static int zza(Context context, JobInfo jobInfo, String string, String string2) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (zzadk == null || !zzadm.zzfy() || context.checkSelfPermission("android.permission.UPDATE_DEVICE_STATS") != 0) {
            return jobScheduler.schedule(jobInfo);
        }
        return new zzdx(jobScheduler).zza(jobInfo, string, zzdx.zzfw(), string2);
    }

    static final /* synthetic */ boolean zzfx() {
        return false;
    }
}

