/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuj;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwd;
import com.google.android.gms.internal.measurement.zzxp;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvh
extends zzuj<Double>
implements zzwd<Double>,
zzxp,
RandomAccess {
    private static final zzvh zzbwb = new zzvh();
    private double[] zzbwc;
    private int size;

    zzvh() {
        this(new double[10], 0);
    }

    private zzvh(double[] dArray, int n) {
        this.zzbwc = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzuh();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbwc, n2, this.zzbwc, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvh)) {
            return super.equals(object);
        }
        zzvh zzvh2 = (zzvh)object;
        if (this.size != zzvh2.size) {
            return false;
        }
        double[] dArray = zzvh2.zzbwc;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzbwc[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzbwc[i]);
            n = n * 31 + zzvz.zzbi(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzuh();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzbwc.length) {
            System.arraycopy(this.zzbwc, n, this.zzbwc, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbwc, 0, dArray, 0, n);
            System.arraycopy(this.zzbwc, n, dArray, n + 1, this.size - n);
            this.zzbwc = dArray;
        }
        this.zzbwc[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzuh();
        zzvz.checkNotNull(collection);
        if (!(collection instanceof zzvh)) {
            return super.addAll(collection);
        }
        zzvh zzvh2 = (zzvh)collection;
        if (zzvh2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvh2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvh2.size;
        if (n > this.zzbwc.length) {
            this.zzbwc = Arrays.copyOf(this.zzbwc, n);
        }
        System.arraycopy(zzvh2.zzbwc, 0, this.zzbwc, this.size, zzvh2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzuh();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbwc[i])) continue;
            System.arraycopy(this.zzbwc, i + 1, this.zzbwc, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzvh zzvh2 = this;
        zzvh2.zzuh();
        zzvh2.zzai(n);
        double d3 = zzvh2.zzbwc[n];
        zzvh2.zzbwc[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvh zzvh2 = this;
        zzvh2.zzuh();
        zzvh2.zzai(n);
        double d = zzvh2.zzbwc[n];
        if (n < zzvh2.size - 1) {
            System.arraycopy(zzvh2.zzbwc, n + 1, zzvh2.zzbwc, n, zzvh2.size - n);
        }
        --zzvh2.size;
        ++zzvh2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzwd zzak(int n) {
        int n2 = n;
        zzvh zzvh2 = this;
        if (n2 < zzvh2.size) {
            throw new IllegalArgumentException();
        }
        return new zzvh(Arrays.copyOf(zzvh2.zzbwc, n2), zzvh2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzvh zzvh2 = this;
        zzvh2.zzai(n);
        return zzvh2.zzbwc[n];
    }

    static {
        zzbwb.zzsw();
    }
}

