/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuz;
import com.google.android.gms.internal.measurement.zzvk;
import com.google.android.gms.internal.measurement.zzvx;
import com.google.android.gms.internal.measurement.zzwe;
import com.google.android.gms.internal.measurement.zzxo;
import com.google.android.gms.internal.measurement.zzzp;
import com.google.android.gms.internal.measurement.zzzq;
import com.google.android.gms.internal.measurement.zzzr;
import com.google.android.gms.internal.measurement.zzzu;
import java.io.IOException;

public final class zzzi {
    private final byte[] buffer;
    private final int zzcfq;
    private final int zzcfr;
    private int zzcfs;
    private int zzbvi;
    private int zzcft;
    private int zzbvk;
    private int zzbvl = Integer.MAX_VALUE;
    private int zzbvc;
    private int zzbvd = 64;
    private int zzbve = 0x4000000;
    private zzuz zzcfu;

    public static zzzi zzn(byte[] byArray) {
        return zzzi.zzj(byArray, 0, byArray.length);
    }

    public static zzzi zzj(byte[] byArray, int n, int n2) {
        return new zzzi(byArray, 0, n2);
    }

    public final int zzuq() throws IOException {
        zzzi zzzi2 = this;
        if (zzzi2.zzcft == zzzi2.zzcfs) {
            this.zzbvk = 0;
            return 0;
        }
        this.zzbvk = this.zzvi();
        if (this.zzbvk == 0) {
            throw new zzzq("Protocol message contained an invalid tag (zero).");
        }
        return this.zzbvk;
    }

    public final void zzao(int n) throws zzzq {
        if (this.zzbvk != n) {
            throw new zzzq("Protocol message end-group tag did not match expected tag.");
        }
    }

    public final boolean zzap(int n) throws IOException {
        switch (n & 7) {
            case 0: {
                this.zzvi();
                return true;
            }
            case 1: {
                this.zzvl();
                return true;
            }
            case 2: {
                this.zzat(this.zzvi());
                return true;
            }
            case 3: {
                int n2;
                zzzi zzzi2 = this;
                while ((n2 = zzzi2.zzuq()) != 0 && zzzi2.zzap(n2)) {
                }
                this.zzao(n >>> 3 << 3 | 4);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.zzvk();
                return true;
            }
        }
        throw new zzzq("Protocol message tag had invalid wire type.");
    }

    public final boolean zzuw() throws IOException {
        return this.zzvi() != 0;
    }

    public final String readString() throws IOException {
        int n = this.zzvi();
        if (n < 0) {
            throw zzzq.zzzl();
        }
        if (n > this.zzcfs - this.zzcft) {
            throw zzzq.zzzk();
        }
        String string = new String(this.buffer, this.zzcft, n, zzzp.UTF_8);
        this.zzcft += n;
        return string;
    }

    public final void zza(zzzr zzzr2, int n) throws IOException {
        if (this.zzbvc >= this.zzbvd) {
            throw zzzq.zzzn();
        }
        ++this.zzbvc;
        zzzr2.zza(this);
        this.zzao(n << 3 | 4);
        --this.zzbvc;
    }

    public final void zza(zzzr zzzr2) throws IOException {
        int n = this.zzvi();
        if (this.zzbvc >= this.zzbvd) {
            throw zzzq.zzzn();
        }
        int n2 = this.zzar(n);
        ++this.zzbvc;
        zzzr2.zza(this);
        this.zzao(0);
        --this.zzbvc;
        this.zzas(n2);
    }

    public final int zzvi() throws IOException {
        byte by = this.zzvn();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.zzvn();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = this.zzvn();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = this.zzvn();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    int n2 = n | (by & 0x7F) << 21;
                    by = this.zzvn();
                    n = n2 | by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.zzvn() < 0) continue;
                            return n;
                        }
                        throw zzzq.zzzm();
                    }
                }
            }
        }
        return n;
    }

    public final long zzvj() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzvn();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzzq.zzzm();
    }

    public final int zzvk() throws IOException {
        byte by = this.zzvn();
        byte by2 = this.zzvn();
        byte by3 = this.zzvn();
        byte by4 = this.zzvn();
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public final long zzvl() throws IOException {
        byte by = this.zzvn();
        byte by2 = this.zzvn();
        byte by3 = this.zzvn();
        byte by4 = this.zzvn();
        byte by5 = this.zzvn();
        byte by6 = this.zzvn();
        byte by7 = this.zzvn();
        byte by8 = this.zzvn();
        return (long)by & 0xFFL | ((long)by2 & 0xFFL) << 8 | ((long)by3 & 0xFFL) << 16 | ((long)by4 & 0xFFL) << 24 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 40 | ((long)by7 & 0xFFL) << 48 | ((long)by8 & 0xFFL) << 56;
    }

    private zzzi(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.zzcfq = n;
        this.zzcfr = this.zzcfs = n + n2;
        this.zzcft = n;
    }

    private final zzuz zzze() throws IOException {
        int n;
        int n2;
        if (this.zzcfu == null) {
            this.zzcfu = zzuz.zzd(this.buffer, this.zzcfq, this.zzcfr);
        }
        if ((n2 = this.zzcfu.zzvh()) > (n = this.zzcft - this.zzcfq)) {
            throw new IOException(String.format("CodedInputStream read ahead of CodedInputByteBufferNano: %s > %s", n2, n));
        }
        this.zzcfu.zzat(n - n2);
        this.zzcfu.zzaq(this.zzbvd - this.zzbvc);
        return this.zzcfu;
    }

    public final <T extends zzvx<T, ?>> T zza(zzxo<T> zzxo2) throws IOException {
        try {
            zzvx zzvx2 = (zzvx)this.zzze().zza(zzxo2, zzvk.zzvz());
            this.zzap(this.zzbvk);
            return (T)zzvx2;
        }
        catch (zzwe zzwe2) {
            throw new zzzq("", zzwe2);
        }
    }

    public final int zzar(int n) throws zzzq {
        if (n < 0) {
            throw zzzq.zzzl();
        }
        int n2 = this.zzbvl;
        if ((n += this.zzcft) > n2) {
            throw zzzq.zzzk();
        }
        this.zzbvl = n;
        this.zzvm();
        return n2;
    }

    private final void zzvm() {
        this.zzcfs += this.zzbvi;
        int n = this.zzcfs;
        if (n > this.zzbvl) {
            this.zzbvi = n - this.zzbvl;
            this.zzcfs -= this.zzbvi;
            return;
        }
        this.zzbvi = 0;
    }

    public final void zzas(int n) {
        this.zzbvl = n;
        this.zzvm();
    }

    public final int zzzf() {
        if (this.zzbvl == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.zzcft;
        return this.zzbvl - n;
    }

    public final int getPosition() {
        return this.zzcft - this.zzcfq;
    }

    public final byte[] zzs(int n, int n2) {
        if (n2 == 0) {
            return zzzu.zzcgs;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.zzcfq + n;
        System.arraycopy(this.buffer, n3, byArray, 0, n2);
        return byArray;
    }

    public final void zzca(int n) {
        this.zzt(n, this.zzbvk);
    }

    final void zzt(int n, int n2) {
        if (n > this.zzcft - this.zzcfq) {
            int n3 = this.zzcft - this.zzcfq;
            throw new IllegalArgumentException(new StringBuilder(50).append("Position ").append(n).append(" is beyond current ").append(n3).toString());
        }
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad position ").append(n).toString());
        }
        this.zzcft = this.zzcfq + n;
        this.zzbvk = n2;
    }

    private final byte zzvn() throws IOException {
        if (this.zzcft == this.zzcfs) {
            throw zzzq.zzzk();
        }
        return this.buffer[this.zzcft++];
    }

    private final void zzat(int n) throws IOException {
        if (n < 0) {
            throw zzzq.zzzl();
        }
        if (this.zzcft + n > this.zzbvl) {
            this.zzat(this.zzbvl - this.zzcft);
            throw zzzq.zzzk();
        }
        if (n <= this.zzcfs - this.zzcft) {
            this.zzcft += n;
            return;
        }
        throw zzzq.zzzk();
    }
}

