/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzta;
import com.google.android.gms.internal.measurement.zzuq;
import com.google.android.gms.internal.measurement.zzuu;
import com.google.android.gms.internal.measurement.zzwg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzty
extends zzta<Double>
implements zzuu<Double>,
zzwg,
RandomAccess {
    private static final zzty zzbuz = new zzty();
    private double[] zzbva;
    private int size;

    zzty() {
        this(new double[10], 0);
    }

    private zzty(double[] dArray, int n) {
        this.zzbva = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzua();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbva, n2, this.zzbva, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzty)) {
            return super.equals(object);
        }
        zzty zzty2 = (zzty)object;
        if (this.size != zzty2.size) {
            return false;
        }
        double[] dArray = zzty2.zzbva;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzbva[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzbva[i]);
            n = n * 31 + zzuq.zzbd(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzua();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
        if (this.size < this.zzbva.length) {
            System.arraycopy(this.zzbva, n, this.zzbva, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbva, 0, dArray, 0, n);
            System.arraycopy(this.zzbva, n, dArray, n + 1, this.size - n);
            this.zzbva = dArray;
        }
        this.zzbva[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzua();
        zzuq.checkNotNull(collection);
        if (!(collection instanceof zzty)) {
            return super.addAll(collection);
        }
        zzty zzty2 = (zzty)collection;
        if (zzty2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzty2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzty2.size;
        if (n > this.zzbva.length) {
            this.zzbva = Arrays.copyOf(this.zzbva, n);
        }
        System.arraycopy(zzty2.zzbva, 0, this.zzbva, this.size, zzty2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzua();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbva[i])) continue;
            System.arraycopy(this.zzbva, i + 1, this.zzbva, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
    }

    private final String zzak(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzty zzty2 = this;
        zzty2.zzua();
        zzty2.zzaj(n);
        double d3 = zzty2.zzbva[n];
        zzty2.zzbva[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzty zzty2 = this;
        zzty2.zzua();
        zzty2.zzaj(n);
        double d = zzty2.zzbva[n];
        if (n < zzty2.size - 1) {
            System.arraycopy(zzty2.zzbva, n + 1, zzty2.zzbva, n, zzty2.size - n - 1);
        }
        --zzty2.size;
        ++zzty2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzuu zzal(int n) {
        int n2 = n;
        zzty zzty2 = this;
        if (n2 < zzty2.size) {
            throw new IllegalArgumentException();
        }
        return new zzty(Arrays.copyOf(zzty2.zzbva, n2), zzty2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzty zzty2 = this;
        zzty2.zzaj(n);
        return zzty2.zzbva[n];
    }

    static {
        zzbuz.zzsw();
    }
}

