/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzta;
import com.google.android.gms.internal.measurement.zzuq;
import com.google.android.gms.internal.measurement.zzuu;
import com.google.android.gms.internal.measurement.zzwg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzul
extends zzta<Float>
implements zzuu<Float>,
zzwg,
RandomAccess {
    private static final zzul zzbyb = new zzul();
    private float[] zzbyc;
    private int size;

    zzul() {
        this(new float[10], 0);
    }

    private zzul(float[] fArray, int n) {
        this.zzbyc = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzua();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbyc, n2, this.zzbyc, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzul)) {
            return super.equals(object);
        }
        zzul zzul2 = (zzul)object;
        if (this.size != zzul2.size) {
            return false;
        }
        float[] fArray = zzul2.zzbyc;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzbyc[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzbyc[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzua();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
        if (this.size < this.zzbyc.length) {
            System.arraycopy(this.zzbyc, n, this.zzbyc, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbyc, 0, fArray, 0, n);
            System.arraycopy(this.zzbyc, n, fArray, n + 1, this.size - n);
            this.zzbyc = fArray;
        }
        this.zzbyc[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzua();
        zzuq.checkNotNull(collection);
        if (!(collection instanceof zzul)) {
            return super.addAll(collection);
        }
        zzul zzul2 = (zzul)collection;
        if (zzul2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzul2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzul2.size;
        if (n > this.zzbyc.length) {
            this.zzbyc = Arrays.copyOf(this.zzbyc, n);
        }
        System.arraycopy(zzul2.zzbyc, 0, this.zzbyc, this.size, zzul2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzua();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzbyc[i]))) continue;
            System.arraycopy(this.zzbyc, i + 1, this.zzbyc, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
    }

    private final String zzak(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzul zzul2 = this;
        zzul2.zzua();
        zzul2.zzaj(n);
        float f3 = zzul2.zzbyc[n];
        zzul2.zzbyc[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzul zzul2 = this;
        zzul2.zzua();
        zzul2.zzaj(n);
        float f = zzul2.zzbyc[n];
        if (n < zzul2.size - 1) {
            System.arraycopy(zzul2.zzbyc, n + 1, zzul2.zzbyc, n, zzul2.size - n - 1);
        }
        --zzul2.size;
        ++zzul2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzuu zzal(int n) {
        int n2 = n;
        zzul zzul2 = this;
        if (n2 < zzul2.size) {
            throw new IllegalArgumentException();
        }
        return new zzul(Arrays.copyOf(zzul2.zzbyc, n2), zzul2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzul zzul2 = this;
        zzul2.zzaj(n);
        return Float.valueOf(zzul2.zzbyc[n]);
    }

    static {
        zzbyb.zzsw();
    }
}

