/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzku;
import com.google.android.gms.internal.measurement.zzkw;
import com.google.android.gms.internal.measurement.zzmn;
import com.google.android.gms.internal.measurement.zznt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzna
extends zzku
implements RandomAccess,
zzmn,
zznt {
    private static final long[] zza = new long[0];
    private static final zzna zzb = new zzna(zza, 0, false);
    private long[] zzc;
    private int zzd;

    public static zzna zze() {
        return zzb;
    }

    zzna() {
        this(zza, 0, true);
    }

    private zzna(long[] lArray, int n, boolean bl) {
        super(bl);
        this.zzc = lArray;
        this.zzd = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcF();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzc, n2, this.zzc, n, this.zzd - n2);
        this.zzd -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzna)) {
            return super.equals(object);
        }
        object = (zzna)object;
        if (this.zzd != ((zzna)object).zzd) {
            return false;
        }
        long[] lArray = ((zzna)object).zzc;
        for (int i = 0; i < this.zzd; ++i) {
            if (this.zzc[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.zzd; ++i) {
            n *= 31;
            long l = this.zzc[i];
            long l2 = l ^ l >>> 32;
            n += (int)l2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final zzmn zzd(int n) {
        long[] lArray;
        if (n < this.zzd) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            lArray = zza;
            return new zzna(lArray, this.zzd, true);
        }
        lArray = Arrays.copyOf(this.zzc, n);
        return new zzna(lArray, this.zzd, true);
    }

    @Override
    public final long zzc(int n) {
        this.zzj(n);
        return this.zzc[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.zzd;
        for (int i = 0; i < n; ++i) {
            if (this.zzc[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.zzd;
    }

    public final void zzf(long l) {
        this.zzcF();
        int n = this.zzc.length;
        if (this.zzd == n) {
            long[] lArray = new long[zzna.zzi(n)];
            System.arraycopy(this.zzc, 0, lArray, 0, this.zzd);
            this.zzc = lArray;
        }
        this.zzc[this.zzd++] = l;
    }

    @Override
    public final boolean addAll(Collection collection) {
        int n;
        this.zzcF();
        if (collection != null) {
            if (!(collection instanceof zzna)) {
                return super.addAll(collection);
            }
            collection = (zzna)collection;
            n = ((zzna)collection).zzd;
            if (n == 0) {
                return false;
            }
            int n2 = this.zzd;
            if (Integer.MAX_VALUE - n2 < n) {
                throw new OutOfMemoryError();
            }
            long[] lArray = this.zzc;
            if ((n = n2 + n) > lArray.length) {
                this.zzc = Arrays.copyOf(lArray, n);
            }
        } else {
            throw null;
        }
        System.arraycopy(((zzna)collection).zzc, 0, this.zzc, this.zzd, ((zzna)collection).zzd);
        this.zzd = n;
        ++this.modCount;
        return true;
    }

    final void zzh(int n) {
        int n2 = this.zzc.length;
        if (n <= n2) {
            return;
        }
        if (n2 != 0) {
            while (n2 < n) {
                n2 = zzna.zzi(n2);
            }
            this.zzc = Arrays.copyOf(this.zzc, n2);
            return;
        }
        this.zzc = new long[Math.max(n, 10)];
    }

    private static int zzi(int n) {
        return Math.max(n * 3 / 2 + 1, 10);
    }

    private final void zzj(int n) {
        if (n < 0 || n >= this.zzd) {
            throw new IndexOutOfBoundsException(this.zzk(n));
        }
    }

    private final String zzk(int n) {
        String string = "Index:";
        String string2 = ", Size:";
        return zzkw.zza(this.zzd, n, (byte)13, string, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final /* synthetic */ void add(int n, Object object) {
        int n2;
        long l = (Long)object;
        this.zzcF();
        if (n < 0 || n > (n2 = this.zzd)) {
            throw new IndexOutOfBoundsException(this.zzk(n));
        }
        int n3 = n + 1;
        long[] lArray = this.zzc;
        int n4 = lArray.length;
        if (n2 < n4) {
            System.arraycopy(lArray, n, lArray, n3, n2 - n);
        } else {
            long[] lArray2 = new long[zzna.zzi(n4)];
            System.arraycopy(this.zzc, 0, lArray2, 0, n);
            System.arraycopy(this.zzc, n, lArray2, n3, this.zzd - n);
            this.zzc = lArray2;
        }
        this.zzc[n] = l;
        ++this.zzd;
        ++this.modCount;
    }

    public final /* synthetic */ Object get(int n) {
        this.zzj(n);
        return this.zzc[n];
    }
}

