/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfv
extends zzdj<Long>
implements zzff,
zzgt,
RandomAccess {
    private static final zzfv zzain = new zzfv(new long[0], 0);
    private long[] zzaio;
    private int size;

    public static zzfv zznk() {
        return zzain;
    }

    zzfv() {
        this(new long[10], 0);
    }

    private zzfv(long[] lArray, int n) {
        this.zzaio = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzka();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaio, n2, this.zzaio, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfv)) {
            return super.equals(object);
        }
        zzfv zzfv2 = (zzfv)object;
        if (this.size != zzfv2.size) {
            return false;
        }
        long[] lArray = zzfv2.zzaio;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzaio[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzfb.zzba(this.zzaio[i]);
        }
        return n;
    }

    @Override
    public final zzff zzav(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfv(Arrays.copyOf(this.zzaio, n), this.size);
    }

    @Override
    public final long getLong(int n) {
        this.zzo(n);
        return this.zzaio[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzbb(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzka();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
        if (this.size < this.zzaio.length) {
            System.arraycopy(this.zzaio, n, this.zzaio, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaio, 0, lArray, 0, n);
            System.arraycopy(this.zzaio, n, lArray, n + 1, this.size - n);
            this.zzaio = lArray;
        }
        this.zzaio[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzka();
        zzfb.checkNotNull(collection);
        if (!(collection instanceof zzfv)) {
            return super.addAll(collection);
        }
        zzfv zzfv2 = (zzfv)collection;
        if (zzfv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfv2.size;
        if (n > this.zzaio.length) {
            this.zzaio = Arrays.copyOf(this.zzaio, n);
        }
        System.arraycopy(zzfv2.zzaio, 0, this.zzaio, this.size, zzfv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzka();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaio[i])) continue;
            System.arraycopy(this.zzaio, i + 1, this.zzaio, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzo(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
    }

    private final String zzp(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfv zzfv2 = this;
        zzfv2.zzka();
        zzfv2.zzo(n);
        long l3 = zzfv2.zzaio[n];
        zzfv2.zzaio[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfv zzfv2 = this;
        zzfv2.zzka();
        zzfv2.zzo(n);
        long l = zzfv2.zzaio[n];
        if (n < zzfv2.size - 1) {
            System.arraycopy(zzfv2.zzaio, n + 1, zzfv2.zzaio, n, zzfv2.size - n - 1);
        }
        --zzfv2.size;
        ++zzfv2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzfg zzq(int n) {
        return this.zzav(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzain.zzjz();
    }
}

