/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzeg
extends zzf {
    private final zzey zzqj;
    private zzam zzqk;
    private volatile Boolean zzql;
    private final zzab zzqm;
    private final zzfo zzqn;
    private final List<Runnable> zzqo = new ArrayList<Runnable>();
    private final zzab zzqp;

    protected zzeg(zzby zzby2) {
        super(zzby2);
        this.zzqn = new zzfo(zzby2.zzz());
        this.zzqj = new zzey(this);
        this.zzqm = new zzeh(this, zzby2);
        this.zzqp = new zzeq(this, zzby2);
    }

    @Override
    protected final boolean zzak() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzct)this).zzq();
        this.zzah();
        return this.zzqk != null;
    }

    @WorkerThread
    protected final void zzfe() {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(true);
        this.zzd(new zzer(this, zzm2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzam zzam2, AbstractSafeParcelable abstractSafeParcelable, zzm zzm2) {
        ((zzct)this).zzq();
        ((zzct)this).zzo();
        this.zzah();
        boolean bl = this.zzff();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zze)this).zzw().zzc(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzaj) {
                    try {
                        zzam2.zza((zzaj)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzct)this).zzad().zzda().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzga) {
                    try {
                        zzam2.zza((zzga)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzct)this).zzad().zzda().zza("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzr) {
                    try {
                        zzam2.zza((zzr)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzct)this).zzad().zzda().zza("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzct)this).zzad().zzda().zzaq("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzaj zzaj2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzaj2));
        ((zzct)this).zzq();
        this.zzah();
        boolean bl = this.zzff();
        boolean bl2 = bl && ((zze)this).zzw().zza(zzaj2);
        zzm zzm2 = this.zzi(true);
        this.zzd(new zzes(this, bl, bl2, zzaj2, zzm2, string));
    }

    @WorkerThread
    protected final void zzd(zzr zzr2) {
        Preconditions.checkNotNull((Object)((Object)zzr2));
        ((zzct)this).zzq();
        this.zzah();
        zzq zzq2 = ((zzct)this).zzag();
        boolean bl = true;
        boolean bl2 = true && ((zze)this).zzw().zzc(zzr2);
        zzr zzr3 = new zzr(zzr2);
        zzm zzm2 = this.zzi(true);
        this.zzd(new zzet(this, bl, bl2, zzr3, zzm2, zzr2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzr>> atomicReference, String string, String string2, String string3) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzeu(this, atomicReference, string, string2, string3, zzm2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzq zzq2, String string, String string2) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzev(this, string, string2, zzm2, zzq2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzga>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzew(this, atomicReference, string, string2, string3, bl, zzm2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzq zzq2, String string, String string2, boolean bl) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzex(this, string, string2, bl, zzm2, zzq2));
    }

    @WorkerThread
    protected final void zzb(zzga zzga2) {
        ((zzct)this).zzq();
        this.zzah();
        boolean bl = this.zzff() && ((zze)this).zzw().zza(zzga2);
        zzm zzm2 = this.zzi(true);
        this.zzd(new zzei(this, bl, zzga2, zzm2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzga>> atomicReference, boolean bl) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzej(this, atomicReference, zzm2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzct)this).zzq();
        ((zzct)this).zzo();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        if (this.zzff()) {
            ((zze)this).zzw().resetAnalyticsData();
        }
        this.zzd(new zzek(this, zzm2));
    }

    private final boolean zzff() {
        zzq zzq2 = ((zzct)this).zzag();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzel(this, atomicReference, zzm2));
    }

    @WorkerThread
    public final void getAppInstanceId(com.google.android.gms.internal.measurement.zzq zzq2) {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(false);
        this.zzd(new zzem(this, zzm2, zzq2));
    }

    @WorkerThread
    protected final void zzfb() {
        ((zzct)this).zzq();
        this.zzah();
        zzm zzm2 = this.zzi(true);
        this.zzd(new zzen(this, zzm2));
    }

    @WorkerThread
    protected final void zza(zzec zzec2) {
        ((zzct)this).zzq();
        this.zzah();
        this.zzd(new zzeo(this, zzec2));
    }

    @WorkerThread
    private final void zzfg() {
        ((zzct)this).zzq();
        this.zzqn.start();
        this.zzqm.zzv((Long)zzal.zzhj.get(null));
    }

    @WorkerThread
    final void zzfh() {
        zzq zzq2;
        Boolean bl;
        zzeg zzeg2;
        ((zzct)this).zzq();
        this.zzah();
        if (this.isConnected()) {
            return;
        }
        if (this.zzql == null) {
            boolean bl2;
            zzeg2 = this;
            ((zzct)zzeg2).zzq();
            zzeg2.zzah();
            bl = ((zzct)zzeg2).zzae().zzdu();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzq2 = ((zzct)zzeg2).zzag();
                if (((zze)zzeg2).zzt().zzcy() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzct)zzeg2).zzad().zzdi().zzaq("Checking service availability");
                    int n = ((zzct)zzeg2).zzab().zzd(12451000);
                    switch (n) {
                        case 0: {
                            ((zzct)zzeg2).zzad().zzdi().zzaq("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzct)zzeg2).zzad().zzdi().zzaq("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzct)zzeg2).zzad().zzdd().zzaq("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzct)zzeg2).zzad().zzdh().zzaq("Service container out of date");
                            if (((zzct)zzeg2).zzab().zzgm() < 15000) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzct)zzeg2).zzae().zzdu();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzct)zzeg2).zzad().zzdd().zzaq("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzct)zzeg2).zzad().zzdd().zzaq("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzct)zzeg2).zzad().zzdd().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzct)zzeg2).zzaf().zzbw()) {
                    ((zzct)zzeg2).zzad().zzda().zzaq("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzct)zzeg2).zzae().zzd(bl4);
                }
                bl2 = bl4;
            }
            this.zzql = bl2;
        }
        if (this.zzql.booleanValue()) {
            this.zzqj.zzfm();
            return;
        }
        if (!((zzct)this).zzaf().zzbw()) {
            Intent intent;
            zzeg2 = this;
            zzq2 = ((zzct)zzeg2).zzag();
            bl = ((zzct)zzeg2).getContext().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzct)zzeg2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzq2 = ((zzct)this).zzag();
                intent2.setComponent(new ComponentName(((zzct)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzqj.zzb(intent2);
                return;
            }
            ((zzct)this).zzad().zzda().zzaq("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzfi() {
        return this.zzql;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzam zzam2) {
        ((zzct)this).zzq();
        Preconditions.checkNotNull((Object)zzam2);
        this.zzqk = zzam2;
        this.zzfg();
        this.zzfk();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzct)this).zzq();
        this.zzah();
        this.zzqj.zzfl();
        try {
            ConnectionTracker.getInstance().unbindService(((zzct)this).getContext(), (ServiceConnection)this.zzqj);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzqk = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzct)this).zzq();
        if (this.zzqk != null) {
            this.zzqk = null;
            ((zzct)this).zzad().zzdi().zza("Disconnected from device MeasurementService", componentName);
            zzeg zzeg2 = this;
            ((zzct)zzeg2).zzq();
            zzeg2.zzfh();
        }
    }

    @WorkerThread
    private final void zzfj() {
        ((zzct)this).zzq();
        if (!this.isConnected()) {
            return;
        }
        ((zzct)this).zzad().zzdi().zzaq("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzd(Runnable runnable) throws IllegalStateException {
        ((zzct)this).zzq();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzqo.size() >= 1000L) {
            ((zzct)this).zzad().zzda().zzaq("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzqo.add(runnable);
        this.zzqp.zzv(60000L);
        this.zzfh();
    }

    @WorkerThread
    private final void zzfk() {
        ((zzct)this).zzq();
        ((zzct)this).zzad().zzdi().zza("Processing queued up service tasks", this.zzqo.size());
        for (Runnable runnable : this.zzqo) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzct)this).zzad().zzda().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzqo.clear();
        this.zzqp.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzm zzi(boolean bl) {
        zzq zzq2 = ((zzct)this).zzag();
        return ((zze)this).zzt().zzak(bl ? ((zzct)this).zzad().zzdk() : null);
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, zzaj zzaj2, String string) {
        ((zzct)this).zzq();
        this.zzah();
        int n = ((zzct)this).zzab().zzd(12451000);
        if (n != 0) {
            ((zzct)this).zzad().zzdd().zzaq("Not bundling data. Service unavailable or out of date");
            ((zzct)this).zzab().zza(zzq2, new byte[0]);
            return;
        }
        this.zzd(new zzep(this, zzaj2, string, zzq2));
    }

    static /* synthetic */ zzey zza(zzeg zzeg2) {
        return zzeg2.zzqj;
    }

    static /* synthetic */ void zza(zzeg zzeg2, ComponentName componentName) {
        zzeg2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzam zza(zzeg zzeg2, zzam zzam2) {
        zzeg2.zzqk = null;
        return null;
    }

    static /* synthetic */ void zzb(zzeg zzeg2) {
        zzeg2.zzfk();
    }

    static /* synthetic */ void zzc(zzeg zzeg2) {
        zzeg2.zzfj();
    }

    static /* synthetic */ zzam zzd(zzeg zzeg2) {
        return zzeg2.zzqk;
    }

    static /* synthetic */ void zze(zzeg zzeg2) {
        zzeg2.zzfg();
    }
}

