/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import java.lang.reflect.InvocationTargetException;

public final class zzt
extends zzct {
    private Boolean zzdz;
    @NonNull
    private zzv zzea = zzu.zzec;
    private Boolean zzeb;

    zzt(zzby zzby2) {
        super(zzby2);
        zzal.zza(zzby2);
    }

    final void zza(@NonNull zzv zzv2) {
        this.zzea = zzv2;
    }

    static String zzbo() {
        return zzal.zzgd.get(null);
    }

    @WorkerThread
    public final int zzi(@Size(min=1L) String string) {
        return this.zzb(string, zzal.zzgr);
    }

    public final long zzav() {
        zzq zzq2 = ((zzct)this).zzag();
        return 15300L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzbp() {
        if (this.zzeb == null) {
            zzt zzt2 = this;
            synchronized (zzt2) {
                if (this.zzeb == null) {
                    ApplicationInfo applicationInfo = ((zzct)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzeb = string2 != null && string2.equals(string);
                    }
                    if (this.zzeb == null) {
                        this.zzeb = Boolean.TRUE;
                        ((zzct)this).zzad().zzda().zzaq("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzeb;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzal.zza<Long> zza2) {
        if (string == null) {
            return zza2.get(null);
        }
        String string2 = this.zzea.zzb(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzal.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get(null);
        }
        String string2 = this.zzea.zzb(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get(null);
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzal.zza<Double> zza2) {
        if (string == null) {
            return zza2.get(null);
        }
        String string2 = this.zzea.zzb(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zza2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzal.zza<Boolean> zza2) {
        if (string == null) {
            return zza2.get(null);
        }
        String string2 = this.zzea.zzb(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zza2.get(bl);
    }

    public final boolean zze(String string, zzal.zza<Boolean> zza2) {
        return this.zzd(string, zza2);
    }

    public final boolean zza(zzal.zza<Boolean> zza2) {
        zzal.zza<Boolean> zza3 = zza2;
        return this.zzd(null, zza3);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzj(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzct)this).getContext().getPackageManager() == null) {
                ((zzct)this).zzad().zzda().zzaq("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzct)this).getContext()).getApplicationInfo(((zzct)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzct)this).zzad().zzda().zzaq("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzct)this).zzad().zzda().zzaq("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzct)this).zzad().zzda().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzbq() {
        zzq zzq2 = ((zzct)this).zzag();
        Boolean bl = this.zzj("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzbr() {
        zzq zzq2 = ((zzct)this).zzag();
        return this.zzj("firebase_analytics_collection_enabled");
    }

    public static long zzbs() {
        return zzal.zzhg.get(null);
    }

    public static long zzbt() {
        return zzal.zzgg.get(null);
    }

    public final String zzbu() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzct)this).zzad().zzda().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzct)this).zzad().zzda().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzct)this).zzad().zzda().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzct)this).zzad().zzda().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzbv() {
        return zzal.zzgc.get(null);
    }

    public final boolean zzk(String string) {
        return "1".equals(this.zzea.zzb(string, "gaia_collection_enabled"));
    }

    public final boolean zzl(String string) {
        return "1".equals(this.zzea.zzb(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzm(String string) {
        return this.zzd(string, zzal.zzhq);
    }

    @WorkerThread
    final boolean zzn(String string) {
        return this.zzd(string, zzal.zzhs);
    }

    @WorkerThread
    final boolean zzo(String string) {
        return this.zzd(string, zzal.zzht);
    }

    @WorkerThread
    final boolean zzp(String string) {
        return this.zzd(string, zzal.zzhk);
    }

    @WorkerThread
    final String zzq(String string) {
        zzal.zza<String> zza2 = zzal.zzhl;
        String string2 = string;
        zzt zzt2 = this;
        if (string2 == null) {
            return zza2.get(null);
        }
        return zza2.get(zzt2.zzea.zzb(string2, zza2.getKey()));
    }

    final boolean zzr(String string) {
        return this.zzd(string, zzal.zzhu);
    }

    @WorkerThread
    final boolean zzs(String string) {
        return this.zzd(string, zzal.zzhv);
    }

    final boolean zzt(String string) {
        return this.zzd(string, zzal.zzhx);
    }

    @WorkerThread
    final boolean zzu(String string) {
        return this.zzd(string, zzal.zzhy);
    }

    @WorkerThread
    final boolean zzv(String string) {
        return this.zzd(string, zzal.zzhz);
    }

    @WorkerThread
    final boolean zzw(String string) {
        return this.zzd(string, zzal.zzib);
    }

    @WorkerThread
    final boolean zzbw() {
        if (this.zzdz == null) {
            this.zzdz = this.zzj("app_measurement_lite");
            if (this.zzdz == null) {
                this.zzdz = false;
            }
        }
        return this.zzdz != false || !this.zzl.zzep();
    }

    @WorkerThread
    final boolean zzx(String string) {
        return this.zzd(string, zzal.zzia);
    }

    @WorkerThread
    static boolean zzbx() {
        return zzal.zzic.get(null);
    }

    @WorkerThread
    final boolean zzy(String string) {
        return this.zzd(string, zzal.zzid);
    }

    @WorkerThread
    final boolean zzz(String string) {
        return this.zzd(string, zzal.zzie);
    }

    @WorkerThread
    final boolean zzaa(String string) {
        return this.zzd(string, zzal.zzif);
    }

    @WorkerThread
    final boolean zzab(String string) {
        return this.zzd(string, zzal.zzig);
    }

    @WorkerThread
    final boolean zzac(String string) {
        return this.zzd(string, zzal.zzil);
    }
}

