/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfj
implements zzgh {
    private static volatile zzfj zzoa;
    private final Context zzob;
    private final String zzv;
    private final String zzoc;
    private final String zzod;
    private final boolean zzt;
    private final zzr zzfv;
    private final zzs zzoe;
    private final zzeo zzof;
    private final zzef zzog;
    private final zzfc zzoh;
    private final zziw zzoi;
    private final zzjs zzoj;
    private final zzed zzok;
    private final Clock zzac;
    private final zzhq zzol;
    private final zzgp zzom;
    private final zza zzon;
    private final zzhl zzoo;
    private zzeb zzop;
    private zzhv zzoq;
    private zzac zzor;
    private zzdy zzos;
    private zzeu zzot;
    private boolean zzdh = false;
    private Boolean zzou;
    private long zzov;
    private volatile Boolean zzow;
    @VisibleForTesting
    private Boolean zzox;
    @VisibleForTesting
    private Boolean zzoy;
    private int zzoz;
    private AtomicInteger zzpa = new AtomicInteger(0);
    private final long zzdr;

    private zzfj(zzgm zzgm2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgm2);
        Object object2 = zzgm2.zzob;
        this.zzfv = new zzr((Context)object2);
        zzak.zza(this.zzfv);
        this.zzob = zzgm2.zzob;
        this.zzv = zzgm2.zzv;
        this.zzoc = zzgm2.zzoc;
        this.zzod = zzgm2.zzod;
        this.zzt = zzgm2.zzt;
        this.zzow = zzgm2.zzow;
        zzx zzx2 = zzgm2.zzpr;
        if (zzx2 != null && zzx2.zzw != null) {
            object = zzx2.zzw.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzox = (Boolean)object;
            }
            if ((object = zzx2.zzw.get("measurementDeactivated")) instanceof Boolean) {
                this.zzoy = (Boolean)object;
            }
        }
        zzcm.zzr(this.zzob);
        this.zzac = DefaultClock.getInstance();
        this.zzdr = this.zzac.currentTimeMillis();
        object2 = this;
        this.zzoe = new zzs((zzfj)object2);
        object2 = this;
        object = new zzeo((zzfj)object2);
        ((zzge)object).initialize();
        this.zzof = object;
        object2 = this;
        zzef zzef2 = new zzef((zzfj)object2);
        zzef2.initialize();
        this.zzog = zzef2;
        object2 = this;
        zzjs zzjs2 = new zzjs((zzfj)object2);
        zzjs2.initialize();
        this.zzoj = zzjs2;
        object2 = this;
        zzed zzed2 = new zzed((zzfj)object2);
        zzed2.initialize();
        this.zzok = zzed2;
        object2 = this;
        this.zzon = new zza((zzfj)object2);
        object2 = this;
        zzhq zzhq2 = new zzhq((zzfj)object2);
        zzhq2.initialize();
        this.zzol = zzhq2;
        object2 = this;
        zzgp zzgp2 = new zzgp((zzfj)object2);
        zzgp2.initialize();
        this.zzom = zzgp2;
        object2 = this;
        zziw zziw2 = new zziw((zzfj)object2);
        zziw2.initialize();
        this.zzoi = zziw2;
        object2 = this;
        zzhl zzhl2 = new zzhl((zzfj)object2);
        zzhl2.initialize();
        this.zzoo = zzhl2;
        object2 = this;
        zzfc zzfc2 = new zzfc((zzfj)object2);
        zzfc2.initialize();
        this.zzoh = zzfc2;
        boolean bl = zzgm2.zzpr != null && zzgm2.zzpr.zzs != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzr zzr2 = ((zzfj)object2).zzfv;
        if (((zzfj)object2).zzob.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzgp zzgp3 = ((zzfj)object2).zzq();
            if (((zzgf)zzgp3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgf)zzgp3).getContext().getApplicationContext();
                if (zzgp3.zzpu == null) {
                    zzgp3.zzpu = new zzhj(zzgp3, null);
                }
                if (bl3) {
                    zzhj zzhj2 = zzgp3.zzpu;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhj2);
                    zzhj2 = zzgp3.zzpu;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhj2);
                    ((zzgf)zzgp3).zzab().zzgs().zzao("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfj)object2).zzab().zzgn().zzao("Application context is not an Application");
        }
        this.zzoh.zza(new zzfl(this, zzgm2));
    }

    @WorkerThread
    private final void zza(zzgm zzgm2) {
        ((zzgf)this.zzaa()).zzo();
        zzs.zzbm();
        Object object = this;
        zzac zzac2 = new zzac((zzfj)object);
        zzac2.initialize();
        this.zzor = zzac2;
        zzfj zzfj2 = this;
        object = zzgm2;
        zzdy zzdy2 = new zzdy(zzfj2, ((zzgm)object).zzs);
        zzdy2.initialize();
        this.zzos = zzdy2;
        object = this;
        zzeb zzeb2 = new zzeb((zzfj)object);
        zzeb2.initialize();
        this.zzop = zzeb2;
        object = this;
        zzhv zzhv2 = new zzhv((zzfj)object);
        zzhv2.initialize();
        this.zzoq = zzhv2;
        this.zzoj.zzbj();
        this.zzof.zzbj();
        object = this;
        this.zzot = new zzeu((zzfj)object);
        this.zzos.zzbj();
        this.zzab().zzgq().zza("App measurement is starting up, version", this.zzoe.zzao());
        zzr zzr2 = this.zzfv;
        this.zzab().zzgq().zzao("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzr2 = this.zzfv;
        String string = zzdy2.zzag();
        if (TextUtils.isEmpty((CharSequence)this.zzv)) {
            String string2;
            zzeh zzeh2;
            if (this.zzz().zzbr(string)) {
                zzeh2 = this.zzab().zzgq();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzeh2 = this.zzab().zzgq();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzeh2.zzao(string2);
        }
        this.zzab().zzgr().zzao("Debug-level message logging enabled");
        if (this.zzoz != this.zzpa.get()) {
            this.zzab().zzgk().zza("Not all components initialized", this.zzoz, this.zzpa.get());
        }
        this.zzdh = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzgf)this.zzaa()).zzo();
        if (this.zzac().zzlj.get() == 0L) {
            this.zzac().zzlj.set(this.zzac.currentTimeMillis());
        }
        if (Long.valueOf(this.zzac().zzlo.get()) == 0L) {
            this.zzab().zzgs().zza("Persisting first open", this.zzdr);
            this.zzac().zzlo.set(this.zzdr);
        }
        if (!this.zzie()) {
            if (this.isEnabled()) {
                if (!this.zzz().zzbp("android.permission.INTERNET")) {
                    this.zzab().zzgk().zzao("App is missing INTERNET permission");
                }
                if (!this.zzz().zzbp("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzab().zzgk().zzao("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzr zzr2 = this.zzfv;
                if (!Wrappers.packageManager((Context)this.zzob).isCallerInstantApp() && !this.zzoe.zzbw()) {
                    if (!zzez.zzl(this.zzob)) {
                        this.zzab().zzgk().zzao("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzjs.zzb(this.zzob, false)) {
                        this.zzab().zzgk().zzao("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzab().zzgk().zzao("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzr zzr3 = this.zzfv;
            if (!TextUtils.isEmpty((CharSequence)this.zzr().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzr().zzah())) {
                this.zzz();
                if (zzjs.zza(this.zzr().getGmpAppId(), this.zzac().zzhc(), this.zzr().zzah(), this.zzac().zzhd())) {
                    this.zzab().zzgq().zzao("Rechecking which service to use due to a GMP App Id change");
                    this.zzac().zzhf();
                    this.zzu().resetAnalyticsData();
                    this.zzoq.disconnect();
                    this.zzoq.zzis();
                    this.zzac().zzlo.set(this.zzdr);
                    this.zzac().zzlq.zzau(null);
                }
                this.zzac().zzar(this.zzr().getGmpAppId());
                this.zzac().zzas(this.zzr().zzah());
            }
            this.zzq().zzbg(this.zzac().zzlq.zzho());
            zzr3 = this.zzfv;
            if (!TextUtils.isEmpty((CharSequence)this.zzr().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzr().zzah())) {
                boolean bl = this.isEnabled();
                if (!this.zzac().zzhj() && !this.zzoe.zzbp()) {
                    this.zzac().zzf(!bl);
                }
                if (bl) {
                    this.zzq().zzim();
                }
                this.zzs().zza(new AtomicReference<String>());
            }
        }
        this.zzac().zzly.set(this.zzoe.zza(zzak.zziu));
        this.zzac().zzlz.set(this.zzoe.zza(zzak.zziv));
    }

    @Override
    public final zzr zzae() {
        return this.zzfv;
    }

    public final zzs zzad() {
        return this.zzoe;
    }

    public final zzeo zzac() {
        zzfj.zza((zzgf)this.zzof);
        return this.zzof;
    }

    @Override
    public final zzef zzab() {
        zzfj.zza(this.zzog);
        return this.zzog;
    }

    public final zzef zzhs() {
        if (this.zzog != null && this.zzog.isInitialized()) {
            return this.zzog;
        }
        return null;
    }

    @Override
    public final zzfc zzaa() {
        zzfj.zza(this.zzoh);
        return this.zzoh;
    }

    public final zziw zzv() {
        zzfj.zza(this.zzoi);
        return this.zzoi;
    }

    public final zzeu zzht() {
        return this.zzot;
    }

    final zzfc zzhu() {
        return this.zzoh;
    }

    public final zzgp zzq() {
        zzfj.zza(this.zzom);
        return this.zzom;
    }

    public final zzjs zzz() {
        zzfj.zza((zzgf)this.zzoj);
        return this.zzoj;
    }

    public final zzed zzy() {
        zzfj.zza((zzgf)this.zzok);
        return this.zzok;
    }

    public final zzeb zzu() {
        zzfj.zza(this.zzop);
        return this.zzop;
    }

    private final zzhl zzhv() {
        zzfj.zza(this.zzoo);
        return this.zzoo;
    }

    @Override
    public final Context getContext() {
        return this.zzob;
    }

    public final boolean zzhw() {
        return TextUtils.isEmpty((CharSequence)this.zzv);
    }

    public final String zzhx() {
        return this.zzv;
    }

    public final String zzhy() {
        return this.zzoc;
    }

    public final String zzhz() {
        return this.zzod;
    }

    public final boolean zzia() {
        return this.zzt;
    }

    @Override
    public final Clock zzx() {
        return this.zzac;
    }

    public final zzhq zzt() {
        zzfj.zza(this.zzol);
        return this.zzol;
    }

    public final zzhv zzs() {
        zzfj.zza(this.zzoq);
        return this.zzoq;
    }

    public final zzac zzw() {
        zzfj.zza(this.zzor);
        return this.zzor;
    }

    public final zzdy zzr() {
        zzfj.zza(this.zzos);
        return this.zzos;
    }

    public final zza zzp() {
        if (this.zzon == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzon;
    }

    @VisibleForTesting
    public static zzfj zza(Context context, String string, String string2, Bundle bundle) {
        return zzfj.zza(context, new zzx(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfj zza(Context context, zzx zzx2) {
        if (zzx2 != null && (zzx2.origin == null || zzx2.zzv == null)) {
            zzx2 = new zzx(zzx2.zzr, zzx2.zzs, zzx2.zzt, zzx2.zzu, null, null, zzx2.zzw);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzoa == null) {
            Class<zzfj> clazz = zzfj.class;
            synchronized (zzfj.class) {
                if (zzoa == null) {
                    zzgm zzgm2 = new zzgm(context, zzx2);
                    zzoa = new zzfj(zzgm2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzx2 != null && zzx2.zzw != null && zzx2.zzw.containsKey("dataCollectionDefaultEnabled")) {
            zzoa.zza(zzx2.zzw.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzoa;
    }

    private final void zzbi() {
        if (!this.zzdh) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzge zzge2) {
        if (zzge2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzge2.isInitialized()) {
            String string = String.valueOf(zzge2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.isInitialized()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgf zzgf2) {
        if (zzgf2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzow = bl;
    }

    @WorkerThread
    public final boolean zzib() {
        return this.zzow != null && this.zzow != false;
    }

    @WorkerThread
    public final boolean isEnabled() {
        boolean bl;
        ((zzgf)this.zzaa()).zzo();
        this.zzbi();
        if (this.zzoe.zza(zzak.zzil)) {
            if (this.zzoe.zzbp()) {
                return false;
            }
            if (this.zzoy != null && this.zzoy.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzac().zzhg();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzoe.zzbq();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzox != null) {
                return this.zzox;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzoe.zza(zzak.zzig) && this.zzow != null) {
                return this.zzow;
            }
            return true;
        }
        if (this.zzoe.zzbp()) {
            return false;
        }
        Boolean bl4 = this.zzoe.zzbq();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzow != null && ((Boolean)zzak.zzig.get(null)).booleanValue()) {
                bl = this.zzow;
            }
        }
        return this.zzac().zze(bl);
    }

    final long zzic() {
        Long l = this.zzac().zzlo.get();
        if (l == 0L) {
            return this.zzdr;
        }
        return Math.min(this.zzdr, l);
    }

    final void zzm() {
        zzr zzr2 = this.zzfv;
    }

    final void zzl() {
        zzr zzr2 = this.zzfv;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzge zzge2) {
        ++this.zzoz;
    }

    final void zzb(zzg zzg2) {
        ++this.zzoz;
    }

    final void zzid() {
        this.zzpa.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzie() {
        this.zzbi();
        ((zzgf)this.zzaa()).zzo();
        if (this.zzou == null || this.zzov == 0L || this.zzou != null && !this.zzou.booleanValue() && Math.abs(this.zzac.elapsedRealtime() - this.zzov) > 1000L) {
            this.zzov = this.zzac.elapsedRealtime();
            zzr zzr2 = this.zzfv;
            this.zzou = this.zzz().zzbp("android.permission.INTERNET") && this.zzz().zzbp("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzob).isCallerInstantApp() || this.zzoe.zzbw() || zzez.zzl(this.zzob) && zzjs.zzb(this.zzob, false));
            if (this.zzou.booleanValue()) {
                this.zzou = this.zzz().zzr(this.zzr().getGmpAppId(), this.zzr().zzah()) || !TextUtils.isEmpty((CharSequence)this.zzr().zzah());
            }
        }
        return this.zzou;
    }

    @WorkerThread
    public final void zza(@NonNull zzp zzp2) {
        ((zzgf)this.zzaa()).zzo();
        zzfj.zza(this.zzhv());
        String string = this.zzr().zzag();
        Pair<String, Boolean> pair = this.zzac().zzap(string);
        if (!this.zzoe.zzbr().booleanValue() || ((Boolean)pair.second).booleanValue()) {
            this.zzab().zzgr().zzao("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            this.zzz().zzb(zzp2, "");
            return;
        }
        if (!this.zzhv().zzgv()) {
            this.zzab().zzgn().zzao("Network is not available for Deferred Deep Link request. Skipping");
            this.zzz().zzb(zzp2, "");
            return;
        }
        URL uRL = this.zzz().zza(((zzgf)this.zzr()).zzad().zzao(), string, (String)pair.first);
        zzfi zzfi2 = new zzfi(this, zzp2);
        URL uRL2 = uRL;
        String string2 = string;
        zzhl zzhl2 = this.zzhv();
        ((zzgf)zzhl2).zzo();
        zzhl2.zzbi();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfi2);
        ((zzgf)zzhl2).zzaa().zzb(new zzhn(zzhl2, string2, uRL2, null, null, zzfi2));
    }

    final /* synthetic */ void zza(zzp zzp2, String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzp zzp3 = zzp2;
        zzfj zzfj2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfj2.zzab().zzgn().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            zzfj2.zzz().zzb(zzp3, "");
            return;
        }
        if (byArray2.length == 0) {
            zzfj2.zzz().zzb(zzp3, "");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = string3;
            zzjs zzjs2 = zzfj2.zzz();
            ((zzgf)zzjs2).zzm();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgf)zzjs2).getContext().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfj2.zzab().zzgn().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                zzfj2.zzz().zzb(zzp3, "");
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("deeplink", string3);
            bundle.putString("gclid", string4);
            zzfj2.zzom.logEvent("auto", "_cmp", bundle);
            zzfj2.zzz().zzb(zzp3, string3);
            return;
        }
        catch (JSONException jSONException) {
            zzfj2.zzab().zzgk().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            zzfj2.zzz().zzb(zzp3, "");
            return;
        }
    }

    static /* synthetic */ void zza(zzfj zzfj2, zzgm zzgm2) {
        zzfj2.zza(zzgm2);
    }
}

