/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;

@VisibleForTesting
public final class zzin
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzrt;
    private volatile zzec zzru;
    final /* synthetic */ zzhv zzrd;

    protected zzin(zzhv zzhv2) {
        this.zzrd = zzhv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb(Intent intent) {
        ((zzgf)this.zzrd).zzo();
        Context context = ((zzgf)this.zzrd).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzin zzin2 = this;
        synchronized (zzin2) {
            if (this.zzrt) {
                ((zzgf)this.zzrd).zzab().zzgs().zzao("Connection attempt already in progress");
                return;
            }
            ((zzgf)this.zzrd).zzab().zzgs().zzao("Using local app measurement service");
            this.zzrt = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzhv.zza(this.zzrd), 129);
            return;
        }
    }

    @WorkerThread
    public final void zziw() {
        if (this.zzru != null && (this.zzru.isConnected() || this.zzru.isConnecting())) {
            this.zzru.disconnect();
        }
        this.zzru = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzin zzin2 = this;
        synchronized (zzin2) {
            String string;
            if (iBinder == null) {
                this.zzrt = false;
                ((zzgf)this.zzrd).zzab().zzgk().zzao("Service connected with null binder");
                return;
            }
            zzdx zzdx2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzdx2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzdx ? (zzdx)iInterface : new zzdz(iBinder2));
                    ((zzgf)this.zzrd).zzab().zzgs().zzao("Bound to IMeasurementService interface");
                } else {
                    ((zzgf)this.zzrd).zzab().zzgk().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgf)this.zzrd).zzab().zzgk().zzao("Service connect failed to get IMeasurementService");
            }
            if (zzdx2 == null) {
                this.zzrt = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgf)this.zzrd).getContext(), (ServiceConnection)zzhv.zza(this.zzrd));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzdx2;
                ((zzgf)this.zzrd).zzaa().zza(new zzim(this, (zzdx)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgf)this.zzrd).zzab().zzgr().zzao("Service disconnected");
        ((zzgf)this.zzrd).zzaa().zza(new zzip(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzix() {
        ((zzgf)this.zzrd).zzo();
        Context context = ((zzgf)this.zzrd).getContext();
        zzin zzin2 = this;
        synchronized (zzin2) {
            if (this.zzrt) {
                ((zzgf)this.zzrd).zzab().zzgs().zzao("Connection attempt already in progress");
                return;
            }
            if (this.zzru != null && (this.zzru.isConnecting() || this.zzru.isConnected())) {
                ((zzgf)this.zzrd).zzab().zzgs().zzao("Already awaiting connection attempt");
                return;
            }
            this.zzru = new zzec(context, Looper.getMainLooper(), this, this);
            ((zzgf)this.zzrd).zzab().zzgs().zzao("Connecting to remote service");
            this.zzrt = true;
            this.zzru.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzin zzin2 = this;
        synchronized (zzin2) {
            try {
                zzdx zzdx2 = (zzdx)this.zzru.getService();
                ((zzgf)this.zzrd).zzaa().zza(new zzio(this, zzdx2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzru = null;
                this.zzrt = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgf)this.zzrd).zzab().zzgr().zzao("Service connection suspended");
        ((zzgf)this.zzrd).zzaa().zza(new zzir(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzef zzef2 = this.zzrd.zzj.zzhs();
        if (zzef2 != null) {
            zzef2.zzgn().zza("Service connection failed", connectionResult);
        }
        zzin zzin2 = this;
        synchronized (zzin2) {
            this.zzrt = false;
            this.zzru = null;
        }
        ((zzgf)this.zzrd).zzaa().zza(new zziq(this));
    }

    static /* synthetic */ boolean zza(zzin zzin2, boolean bl) {
        zzin2.zzrt = false;
        return false;
    }
}

