/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import java.util.Map;

public final class zza
extends zzd {
    private final Map<String, Long> zzby;
    private final Map<String, Integer> zzbz = new ArrayMap();
    private long zzca;

    public zza(zzfj zzfj2) {
        super(zzfj2);
        this.zzby = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzgf)this).zzab().zzgk().zzao("Ad unit id must be a non-empty string");
            return;
        }
        ((zzgf)this).zzaa().zza(new zzc(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzgf)this).zzm();
        ((zzgf)this).zzo();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzbz.isEmpty()) {
            this.zzca = l;
        }
        if ((n = this.zzbz.get(string)) != null) {
            this.zzbz.put(string, n + 1);
            return;
        }
        if (this.zzbz.size() >= 100) {
            ((zzgf)this).zzab().zzgn().zzao("Too many ads visible");
            return;
        }
        this.zzbz.put(string, 1);
        this.zzby.put(string, l);
    }

    public final void endAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzgf)this).zzab().zzgk().zzao("Ad unit id must be a non-empty string");
            return;
        }
        ((zzgf)this).zzaa().zza(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzgf)this).zzm();
        ((zzgf)this).zzo();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzbz.get(string);
        if (n != null) {
            zzhr zzhr2 = ((zzd)this).zzt().zzin();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbz.remove(string);
                Long l2 = this.zzby.get(string);
                if (l2 == null) {
                    ((zzgf)this).zzab().zzgk().zzao("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzby.remove(string);
                    this.zza(string, l3, zzhr2);
                }
                if (this.zzbz.isEmpty()) {
                    if (this.zzca == 0L) {
                        ((zzgf)this).zzab().zzgk().zzao("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzca, zzhr2);
                    this.zzca = 0L;
                }
                return;
            }
            this.zzbz.put(string, n2);
            return;
        }
        ((zzgf)this).zzab().zzgk().zza("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzhr zzhr2) {
        if (zzhr2 == null) {
            ((zzgf)this).zzab().zzgs().zzao("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzgf)this).zzab().zzgs().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzhq.zza(zzhr2, bundle, true);
        ((zzd)this).zzq().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzhr zzhr2) {
        if (zzhr2 == null) {
            ((zzgf)this).zzab().zzgs().zzao("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzgf)this).zzab().zzgs().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzhq.zza(zzhr2, bundle, true);
        ((zzd)this).zzq().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzc(long l) {
        zzhr zzhr2 = ((zzd)this).zzt().zzin();
        for (String string : this.zzby.keySet()) {
            long l2 = this.zzby.get(string);
            this.zza(string, l - l2, zzhr2);
        }
        if (!this.zzby.isEmpty()) {
            this.zza(l - this.zzca, zzhr2);
        }
        this.zzd(l);
    }

    @WorkerThread
    private final void zzd(long l) {
        for (String string : this.zzby.keySet()) {
            this.zzby.put(string, l);
        }
        if (!this.zzby.isEmpty()) {
            this.zzca = l;
        }
    }

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        zza2.zza(string, l);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        zza2.zzb(string, l);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzd(l);
    }
}

