/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzr;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class zzac
extends zzge {
    private long zzey;
    private String zzez;
    private Boolean zzfa;
    private AccountManager zzfb;
    private Boolean zzfc;
    private long zzfd;

    zzac(zzfj zzfj2) {
        super(zzfj2);
    }

    @Override
    protected final boolean zzbk() {
        Calendar calendar = Calendar.getInstance();
        this.zzey = TimeUnit.MINUTES.convert(calendar.get(15) + calendar.get(16), TimeUnit.MILLISECONDS);
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage().toLowerCase(Locale.ENGLISH);
        String string2 = locale.getCountry().toLowerCase(Locale.ENGLISH);
        this.zzez = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
        return false;
    }

    public final long zzcq() {
        this.zzbi();
        return this.zzey;
    }

    public final String zzcr() {
        this.zzbi();
        return this.zzez;
    }

    public final boolean zzj(Context context) {
        if (this.zzfa == null) {
            zzr zzr2 = ((zzgf)this).zzae();
            this.zzfa = false;
            try {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null) {
                    packageManager.getPackageInfo("com.google.android.gms", 128);
                    this.zzfa = true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return this.zzfa;
    }

    @WorkerThread
    final long zzcs() {
        ((zzgf)this).zzo();
        return this.zzfd;
    }

    @WorkerThread
    final void zzct() {
        ((zzgf)this).zzo();
        this.zzfc = null;
        this.zzfd = 0L;
    }

    @WorkerThread
    final boolean zzcu() {
        ((zzgf)this).zzo();
        long l = ((zzgf)this).zzx().currentTimeMillis();
        if (l - this.zzfd > 86400000L) {
            this.zzfc = null;
        }
        if (this.zzfc != null) {
            return this.zzfc;
        }
        if (ContextCompat.checkSelfPermission((Context)((zzgf)this).getContext(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            ((zzgf)this).zzab().zzgo().zzao("Permission error checking for dasher/unicorn accounts");
            this.zzfd = l;
            this.zzfc = false;
            return false;
        }
        if (this.zzfb == null) {
            this.zzfb = AccountManager.get((Context)((zzgf)this).getContext());
        }
        try {
            Account[] accountArray = (Account[])this.zzfb.getAccountsByTypeAndFeatures("com.google", new String[]{"service_HOSTED"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zzfc = true;
                this.zzfd = l;
                return true;
            }
            accountArray = (Account[])this.zzfb.getAccountsByTypeAndFeatures("com.google", new String[]{"service_uca"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zzfc = true;
                this.zzfd = l;
                return true;
            }
        }
        catch (AuthenticatorException | OperationCanceledException | IOException throwable) {
            ((zzgf)this).zzab().zzgl().zza("Exception checking account types", throwable);
        }
        this.zzfd = l;
        this.zzfc = false;
        return false;
    }
}

