/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzs;
import java.util.List;

public final class zzdy
extends zzg {
    private String zzce;
    private String zzcm;
    private int zzjr;
    private String zzco;
    private String zzjs;
    private long zzjt;
    private long zzcr;
    private long zzs;
    private List<String> zzcw;
    private int zzds;
    private String zzcg;
    private String zzcu;

    zzdy(zzfj zzfj2, long l) {
        super(zzfj2);
        this.zzs = l;
    }

    @Override
    protected final boolean zzbk() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void zzbl() {
        block35: {
            block34: {
                var1_1 = "unknown";
                var2_2 = "Unknown";
                var3_3 = -2147483648;
                var4_4 = "Unknown";
                var5_5 = this.getContext().getPackageName();
                var6_6 = this.getContext().getPackageManager();
                if (var6_6 == null) {
                    this.zzab().zzgk().zza("PackageManager is null, app identity information might be inaccurate. appId", zzef.zzam(var5_5));
                } else {
                    try {
                        var1_1 = var6_6.getInstallerPackageName(var5_5);
                    }
                    catch (IllegalArgumentException v0) {
                        this.zzab().zzgk().zza("Error retrieving app installer package name. appId", zzef.zzam(var5_5));
                    }
                    if (var1_1 == null) {
                        var1_1 = "manual_install";
                    } else if ("com.android.vending".equals(var1_1)) {
                        var1_1 = "";
                    }
                    try {
                        var7_7 = var6_6.getPackageInfo(this.getContext().getPackageName(), 0);
                        if (var7_7 != null) {
                            var8_8 = var6_6.getApplicationLabel(var7_7.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)var8_8)) {
                                var4_4 = var8_8.toString();
                            }
                            var2_2 = var7_7.versionName;
                            var3_3 = var7_7.versionCode;
                        }
                    }
                    catch (PackageManager.NameNotFoundException v1) {
                        this.zzab().zzgk().zza("Error retrieving package info. appId, appName", zzef.zzam(var5_5), var4_4);
                    }
                }
                this.zzce = var5_5;
                this.zzco = var1_1;
                this.zzcm = var2_2;
                this.zzjr = var3_3;
                this.zzjs = var4_4;
                this.zzjt = 0L;
                var16_10 = this.zzae();
                var7_7 = GoogleServices.initialize((Context)this.getContext());
                var8_9 = (var7_7 != null && var7_7.isSuccess() != false) | (TextUtils.isEmpty((CharSequence)this.zzj.zzhx()) == false && "am".equals(this.zzj.zzhy()) != false);
                if (!var8_9) {
                    var13_11 = var7_7;
                    var12_12 = this;
                    if (var13_11 == null) {
                        var12_12.zzab().zzgk().zzao("GoogleService failed to initialize (no status)");
                    } else {
                        var12_12.zzab().zzgk().zza("GoogleService failed to initialize, status", var13_11.getStatusCode(), var13_11.getStatusMessage());
                    }
                }
                var9_13 = false;
                if (var8_9) {
                    var10_14 = this.zzad().zzbq();
                    if (this.zzad().zzbp()) {
                        if (this.zzj.zzhw()) {
                            this.zzab().zzgq().zzao("Collection disabled with firebase_analytics_collection_deactivated=1");
                        }
                    } else if (var10_14 != null && !var10_14.booleanValue()) {
                        if (this.zzj.zzhw()) {
                            this.zzab().zzgq().zzao("Collection disabled with firebase_analytics_collection_enabled=0");
                        }
                    } else if (var10_14 == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                        this.zzab().zzgq().zzao("Collection disabled with google_app_measurement_enable=0");
                    } else {
                        var9_13 = true;
                        this.zzab().zzgs().zzao("Collection enabled");
                    }
                }
                this.zzcg = "";
                this.zzcu = "";
                this.zzcr = 0L;
                var16_10 = this.zzae();
                if (!TextUtils.isEmpty((CharSequence)this.zzj.zzhx()) && "am".equals(this.zzj.zzhy())) {
                    this.zzcu = this.zzj.zzhx();
                }
                try {
                    var10_14 = GoogleServices.getGoogleAppId();
                    v2 = this.zzcg = TextUtils.isEmpty((CharSequence)var10_14) != false ? "" : var10_14;
                    if (!TextUtils.isEmpty((CharSequence)var10_14)) {
                        var11_16 = new StringResourceValueReader(this.getContext());
                        this.zzcu = var11_16.getString("admob_app_id");
                    }
                    if (var9_13) {
                        this.zzab().zzgs().zza("App package, google app id", this.zzce, this.zzcg);
                    }
                }
                catch (IllegalStateException var10_15) {
                    this.zzab().zzgk().zza("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzef.zzam(var5_5), var10_15);
                }
                this.zzcw = null;
                if (!this.zzad().zze(this.zzce, zzak.zzix)) break block35;
                var16_10 = this.zzae();
                var10_14 = this.zzad().zzk("analytics.safelisted_events");
                var13_11 = var10_14;
                var12_12 = this;
                if (var13_11 == null) ** GOTO lbl97
                if (var13_11.size() == 0) {
                    var12_12.zzab().zzgn().zzao("Safelisted event list cannot be empty. Ignoring");
                    v3 = false;
                } else {
                    var14_17 = var13_11.iterator();
                    while (var14_17.hasNext()) {
                        var15_18 = (String)var14_17.next();
                        if (var12_12.zzz().zzq("safelisted event", var15_18)) continue;
                        v3 = false;
                        break block34;
                    }
lbl97:
                    // 2 sources

                    v3 = true;
                }
            }
            if (v3) {
                this.zzcw = var10_14;
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (var6_6 != null) {
                this.zzds = InstantApps.isInstantApp((Context)this.getContext()) != false ? 1 : 0;
                return;
            }
            this.zzds = 0;
            return;
        }
        this.zzds = 0;
    }

    @WorkerThread
    final zzn zzai(String string) {
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        String string2 = this.zzag();
        String string3 = this.getGmpAppId();
        zzgf zzgf2 = this;
        ((zzg)zzgf2).zzbi();
        String string4 = ((zzdy)zzgf2).zzcm;
        long l = this.zzgf();
        zzgf2 = this;
        ((zzg)zzgf2).zzbi();
        String string5 = ((zzdy)zzgf2).zzco;
        long l2 = ((zzgf)this).zzad().zzao();
        zzgf2 = this;
        ((zzg)zzgf2).zzbi();
        zzgf2.zzo();
        if (((zzdy)zzgf2).zzjt == 0L) {
            ((zzdy)zzgf2).zzjt = ((zzdy)zzgf2).zzj.zzz().zzc(zzgf2.getContext(), zzgf2.getContext().getPackageName());
        }
        long l3 = ((zzdy)zzgf2).zzjt;
        boolean bl = this.zzj.isEnabled();
        boolean bl2 = !((zzgf)this).zzac().zzmc;
        zzgf2 = this;
        zzgf2.zzo();
        zzgf2.zzm();
        String string6 = !((zzdy)zzgf2).zzj.isEnabled() ? null : ((zzdy)zzgf2).zzge();
        zzgf2 = this;
        ((zzg)zzgf2).zzbi();
        long l4 = ((zzdy)zzgf2).zzcr;
        long l5 = this.zzj.zzic();
        int n = this.zzgg();
        boolean bl3 = ((zzgf)this).zzad().zzbr();
        zzgf2 = ((zzgf)this).zzad();
        zzgf2.zzm();
        Boolean bl4 = ((zzs)zzgf2).zzj("google_analytics_ssaid_collection_enabled");
        return new zzn(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, l4, l5, n, bl3, bl4 == null || bl4 != false, ((zzgf)this).zzac().zzhi(), this.zzah(), ((zzgf)this).zzad().zze(this.zzag(), zzak.zzij) && (bl4 = ((zzgf)this).zzad().zzj("google_analytics_default_allow_ad_personalization_signals")) != null ? Boolean.valueOf(bl4 == false) : null, this.zzs, ((zzgf)this).zzad().zze(this.zzag(), zzak.zzix) ? this.zzcw : null);
    }

    @WorkerThread
    @VisibleForTesting
    private final String zzge() {
        Object object;
        Class<?> clazz;
        try {
            clazz = ((zzgf)this).getContext().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
            if (clazz == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            object = clazz.getDeclaredMethod("getInstance", Context.class).invoke(null, ((zzgf)this).getContext());
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            ((zzgf)this).zzab().zzgo().zzao("Failed to obtain Firebase Analytics instance");
            return null;
        }
        try {
            return (String)clazz.getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            ((zzgf)this).zzab().zzgp().zzao("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzag() {
        this.zzbi();
        return this.zzce;
    }

    final String getGmpAppId() {
        this.zzbi();
        return this.zzcg;
    }

    final String zzah() {
        this.zzbi();
        return this.zzcu;
    }

    final int zzgf() {
        this.zzbi();
        return this.zzjr;
    }

    final int zzgg() {
        this.zzbi();
        return this.zzds;
    }

    @Nullable
    final List<String> zzbh() {
        return this.zzcw;
    }
}

