/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzix;

@VisibleForTesting
public final class zziq
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzeg zzc;
    final /* synthetic */ zzhy zza;

    protected zziq(zzhy zzhy2) {
        this.zza = zzhy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgj)this.zza).zzd();
        Context context = ((zzgj)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zziq zziq2 = this;
        synchronized (zziq2) {
            if (this.zzb) {
                ((zzgj)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzgj)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzhy.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zziq zziq2 = this;
        synchronized (zziq2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgj)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzeb zzeb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzeb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzeb ? (zzeb)iInterface : new zzed(iBinder2));
                    ((zzgj)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgj)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgj)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzeb2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgj)this.zza).zzn(), (ServiceConnection)zzhy.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzeb2;
                ((zzgj)this.zza).zzq().zza(new zzit(this, (zzeb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgj)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzgj)this.zza).zzq().zza(new zzis(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgj)this.zza).zzd();
        Context context = ((zzgj)this.zza).zzn();
        zziq zziq2 = this;
        synchronized (zziq2) {
            if (this.zzb) {
                ((zzgj)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgj)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzeg(context, Looper.getMainLooper(), this, this);
            ((zzgj)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zziq zziq2 = this;
        synchronized (zziq2) {
            try {
                zzeb zzeb2 = (zzeb)this.zzc.getService();
                ((zzgj)this.zza).zzq().zza(new zziv(this, zzeb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgj)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzgj)this.zza).zzq().zza(new zziu(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzej zzej2 = this.zza.zzw.zzd();
        if (zzej2 != null) {
            zzej2.zzi().zza("Service connection failed", connectionResult);
        }
        zziq zziq2 = this;
        synchronized (zziq2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgj)this.zza).zzq().zza(new zzix(this));
    }

    static /* synthetic */ boolean zza(zziq zziq2, boolean bl) {
        zziq2.zzb = false;
        return false;
    }
}

