/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzs
extends zzgj {
    private Boolean zza;
    @NonNull
    private zzu zzb = zzv.zza;
    private Boolean zzc;

    zzs(zzfn zzfn2) {
        super(zzfn2);
        zzak.zza(zzfn2);
    }

    final void zza(@NonNull zzu zzu2) {
        this.zzb = zzu2;
    }

    static String zze() {
        return zzak.zzd.zza(null);
    }

    @WorkerThread
    public final int zza(@Size(min=1L) String string) {
        return this.zzb(string, zzak.zzr);
    }

    public final long zzf() {
        zzr zzr2 = ((zzgj)this).zzu();
        return 18079L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzg() {
        if (this.zzc == null) {
            zzs zzs2 = this;
            synchronized (zzs2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgj)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgj)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzdy<Long> zzdy2) {
        if (string == null) {
            return zzdy2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzdy2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdy2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzdy2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzdy2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzdy<Integer> zzdy2) {
        if (string == null) {
            return zzdy2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzdy2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdy2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzdy2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzdy2.zza(null);
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzdy<Double> zzdy2) {
        if (string == null) {
            return zzdy2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzdy2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdy2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzdy2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzdy2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzdy<Boolean> zzdy2) {
        if (string == null) {
            return zzdy2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzdy2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdy2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzdy2.zza(bl);
    }

    public final boolean zze(String string, zzdy<Boolean> zzdy2) {
        return this.zzd(string, zzdy2);
    }

    public final boolean zza(zzdy<Boolean> zzdy2) {
        zzdy<Boolean> zzdy3 = zzdy2;
        return this.zzd(null, zzdy3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzaa() {
        try {
            if (((zzgj)this).zzn().getPackageManager() == null) {
                ((zzgj)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgj)this).zzn()).getApplicationInfo(((zzgj)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgj)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgj)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzb(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzaa();
        if (bundle == null) {
            ((zzgj)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzc(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzs zzs2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzs2.zzaa();
        if (bundle == null) {
            ((zzgj)zzs2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgj)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgj)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzh() {
        zzr zzr2 = ((zzgj)this).zzu();
        Boolean bl = this.zzb("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzi() {
        zzr zzr2 = ((zzgj)this).zzu();
        return this.zzb("firebase_analytics_collection_enabled");
    }

    public final Boolean zzj() {
        ((zzgj)this).zzb();
        Boolean bl = this.zzb("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public static long zzk() {
        return zzak.zzag.zza(null);
    }

    public static long zzv() {
        return zzak.zzg.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgj)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgj)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgj)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgj)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public static boolean zzy() {
        return zzak.zzc.zza(null);
    }

    public final boolean zzd(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zze(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzf(String string) {
        return this.zzd(string, zzak.zzaq);
    }

    @WorkerThread
    final boolean zzg(String string) {
        return this.zzd(string, zzak.zzak);
    }

    @WorkerThread
    final String zzh(String string) {
        zzdy<String> zzdy2 = zzak.zzal;
        String string2 = string;
        zzs zzs2 = this;
        if (string2 == null) {
            return zzdy2.zza(null);
        }
        return zzdy2.zza(zzs2.zzb.zza(string2, zzdy2.zza()));
    }

    final boolean zzi(String string) {
        return this.zzd(string, zzak.zzar);
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzd(string, zzak.zzas);
    }

    @WorkerThread
    final boolean zzk(String string) {
        return this.zzd(string, zzak.zzat);
    }

    @WorkerThread
    final boolean zzl(String string) {
        return this.zzd(string, zzak.zzav);
    }

    @WorkerThread
    final boolean zzz() {
        if (this.zza == null) {
            this.zza = this.zzb("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzw.zzt();
    }

    @WorkerThread
    final boolean zzm(String string) {
        return this.zzd(string, zzak.zzau);
    }

    @WorkerThread
    final boolean zzn(String string) {
        return this.zzd(string, zzak.zzaw);
    }

    @WorkerThread
    final boolean zzo(String string) {
        return this.zzd(string, zzak.zzax);
    }

    @WorkerThread
    final boolean zzp(String string) {
        return this.zzd(string, zzak.zzay);
    }

    @WorkerThread
    final boolean zzq(String string) {
        return this.zzd(string, zzak.zzaz);
    }

    @WorkerThread
    final boolean zzr(String string) {
        return this.zzd(string, zzak.zzbe);
    }

    @WorkerThread
    final boolean zzs(String string) {
        return this.zzd(string, zzak.zzbn);
    }
}

