/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzw;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzu
extends zzgh {
    private Boolean zza;
    @NonNull
    private zzw zzb = zzt.zza;
    private Boolean zzc;

    zzu(zzfl zzfl2) {
        super(zzfl2);
        zzam.zza(zzfl2);
    }

    final void zza(@NonNull zzw zzw2) {
        this.zzb = zzw2;
    }

    static String zze() {
        return zzam.zzd.zza(null);
    }

    @WorkerThread
    public final int zza(@Size(min=1L) String string) {
        return this.zzb(string, zzam.zzr);
    }

    public final long zzf() {
        zzp zzp2 = ((zzgh)this).zzu();
        return 18102L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzg() {
        if (this.zzc == null) {
            zzu zzu2 = this;
            synchronized (zzu2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgh)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgh)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzea<Long> zzea2) {
        if (string == null) {
            return zzea2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzea2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzea2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzea2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzea2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzea<Integer> zzea2) {
        if (string == null) {
            return zzea2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzea2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzea2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzea2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzea2.zza(null);
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzea<Double> zzea2) {
        if (string == null) {
            return zzea2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzea2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzea2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzea2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzea2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzea<Boolean> zzea2) {
        if (string == null) {
            return zzea2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzea2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzea2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzea2.zza(bl);
    }

    public final boolean zze(String string, zzea<Boolean> zzea2) {
        return this.zzd(string, zzea2);
    }

    public final boolean zza(zzea<Boolean> zzea2) {
        zzea<Boolean> zzea3 = zzea2;
        return this.zzd(null, zzea3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzaa() {
        try {
            if (((zzgh)this).zzn().getPackageManager() == null) {
                ((zzgh)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgh)this).zzn()).getApplicationInfo(((zzgh)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgh)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgh)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzb(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzaa();
        if (bundle == null) {
            ((zzgh)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzc(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzu zzu2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzu2.zzaa();
        if (bundle == null) {
            ((zzgh)zzu2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgh)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgh)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzh() {
        zzp zzp2 = ((zzgh)this).zzu();
        Boolean bl = this.zzb("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzi() {
        zzp zzp2 = ((zzgh)this).zzu();
        return this.zzb("firebase_analytics_collection_enabled");
    }

    public final Boolean zzj() {
        ((zzgh)this).zzb();
        Boolean bl = this.zzb("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public static long zzk() {
        return zzam.zzag.zza(null);
    }

    public static long zzv() {
        return zzam.zzg.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgh)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgh)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgh)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgh)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public static boolean zzy() {
        return zzam.zzc.zza(null);
    }

    public final boolean zzd(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zze(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzf(String string) {
        return this.zzd(string, zzam.zzaq);
    }

    @WorkerThread
    final boolean zzg(String string) {
        return this.zzd(string, zzam.zzak);
    }

    @WorkerThread
    final String zzh(String string) {
        zzea<String> zzea2 = zzam.zzal;
        String string2 = string;
        zzu zzu2 = this;
        if (string2 == null) {
            return zzea2.zza(null);
        }
        return zzea2.zza(zzu2.zzb.zza(string2, zzea2.zza()));
    }

    @WorkerThread
    final boolean zzi(String string) {
        return this.zzd(string, zzam.zzar);
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzd(string, zzam.zzat);
    }

    @WorkerThread
    final boolean zzz() {
        if (this.zza == null) {
            this.zza = this.zzb("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzw.zzt();
    }

    @WorkerThread
    final boolean zzk(String string) {
        return this.zzd(string, zzam.zzas);
    }

    @WorkerThread
    final boolean zzl(String string) {
        return this.zzd(string, zzam.zzau);
    }

    @WorkerThread
    final boolean zzm(String string) {
        return this.zzd(string, zzam.zzav);
    }

    @WorkerThread
    final boolean zzn(String string) {
        return this.zzd(string, zzam.zzaw);
    }

    @WorkerThread
    final boolean zzo(String string) {
        return this.zzd(string, zzam.zzax);
    }

    @WorkerThread
    final boolean zzp(String string) {
        return this.zzd(string, zzam.zzbc);
    }
}

