/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzkk;
import java.util.Map;

public final class zzif
extends zze {
    @VisibleForTesting
    protected zzig zza;
    private volatile zzig zzb;
    private zzig zzc;
    private final Map<Activity, zzig> zzd = new ArrayMap();
    private zzig zze;
    private String zzf;

    public zzif(zzfx zzfx2) {
        super(zzfx2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzig zzab() {
        this.zzw();
        ((zzgs)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzif.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzkk.zzd(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgs)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgs)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgs)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzig zzig2 = new zzig(string, string2, ((zzgs)this).zzp().zzg());
        this.zzd.put(activity, zzig2);
        this.zza(activity, zzig2, true);
    }

    public final zzig zzac() {
        ((zzgs)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzig zzig2, boolean bl) {
        zzig zzig3;
        zzig zzig4 = zzig3 = this.zzb == null ? this.zzc : this.zzb;
        if (zzig2.zzb == null) {
            zzig2 = new zzig(zzig2.zza, zzif.zza(activity.getClass().getCanonicalName()), zzig2.zzc);
        }
        zzig zzig5 = zzig2;
        this.zzc = this.zzb;
        this.zzb = zzig5;
        ((zzgs)this).zzq().zza(new zzii(this, bl, zzig3, zzig5));
    }

    @WorkerThread
    private final void zza(@NonNull zzig zzig2, boolean bl) {
        ((zzf)this).zze().zza(((zzgs)this).zzm().elapsedRealtime());
        if (((zzf)this).zzk().zza(zzig2.zzd, bl)) {
            zzig2.zzd = false;
        }
    }

    public static void zza(zzig zzig2, Bundle bundle, boolean bl) {
        if (bundle != null && zzig2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzig2.zza != null) {
                bundle.putString("_sn", zzig2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzig2.zzb);
            bundle.putLong("_si", zzig2.zzc);
            return;
        }
        if (bundle != null && zzig2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzig zzig2) {
        ((zzgs)this).zzd();
        zzif zzif2 = this;
        synchronized (zzif2) {
            if (this.zzf == null || this.zzf.equals(string) || zzig2 != null) {
                this.zzf = string;
                this.zze = zzig2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzig zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzig zzig2 = this.zzd.get(activity);
        if (zzig2 == null) {
            String string = zzif.zza(activity.getClass().getCanonicalName());
            zzig2 = new zzig(null, string, ((zzgs)this).zzp().zzg());
            this.zzd.put(activity, zzig2);
        }
        return zzig2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzig zzig2 = new zzig(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzig2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zzig zzig2 = this.zzd(activity);
        this.zza(activity, zzig2, false);
        zzb zzb2 = ((zzf)this).zze();
        long l = ((zzgs)zzb2).zzm().elapsedRealtime();
        ((zzgs)zzb2).zzq().zza(new zzc(zzb2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzig zzig2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgs)this).zzq().zza(new zzih(this, zzig2));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzig zzig2 = this.zzd.get(activity);
        if (zzig2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzig2.zzc);
        bundle2.putString("name", zzig2.zza);
        bundle2.putString("referrer_name", zzig2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzif zzif2, zzig zzig2, boolean bl) {
        zzif2.zza(zzig2, bl);
    }
}

