/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzx
extends zzgs {
    private Boolean zza;
    @NonNull
    private zzz zzb = zzaa.zza;
    private Boolean zzc;

    zzx(zzfx zzfx2) {
        super(zzfx2);
        zzap.zza(zzfx2);
    }

    final void zza(@NonNull zzz zzz2) {
        this.zzb = zzz2;
    }

    static String zze() {
        return zzap.zzd.zza(null);
    }

    @WorkerThread
    public final int zza(@Size(min=1L) String string) {
        return this.zzb(string, zzap.zzr);
    }

    public final long zzf() {
        zzw zzw2 = ((zzgs)this).zzu();
        return 18202L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzg() {
        if (this.zzc == null) {
            zzx zzx2 = this;
            synchronized (zzx2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgs)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgs)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzem<Long> zzem2) {
        if (string == null) {
            return zzem2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzem2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzem2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzem2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzem2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzem<Integer> zzem2) {
        if (string == null) {
            return zzem2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzem2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzem2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzem2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzem2.zza(null);
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzem<Double> zzem2) {
        if (string == null) {
            return zzem2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzem2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzem2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzem2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzem2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzem<Boolean> zzem2) {
        if (string == null) {
            return zzem2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzem2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzem2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzem2.zza(bl);
    }

    public final boolean zze(String string, zzem<Boolean> zzem2) {
        return this.zzd(string, zzem2);
    }

    public final boolean zza(zzem<Boolean> zzem2) {
        zzem<Boolean> zzem3 = zzem2;
        return this.zzd(null, zzem3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzaa() {
        try {
            if (((zzgs)this).zzn().getPackageManager() == null) {
                ((zzgs)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgs)this).zzn()).getApplicationInfo(((zzgs)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgs)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgs)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzb(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzaa();
        if (bundle == null) {
            ((zzgs)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzc(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzx zzx2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzx2.zzaa();
        if (bundle == null) {
            ((zzgs)zzx2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgs)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgs)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzh() {
        zzw zzw2 = ((zzgs)this).zzu();
        Boolean bl = this.zzb("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzi() {
        zzw zzw2 = ((zzgs)this).zzu();
        return this.zzb("firebase_analytics_collection_enabled");
    }

    public final Boolean zzj() {
        ((zzgs)this).zzb();
        Boolean bl = this.zzb("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public static long zzk() {
        return zzap.zzag.zza(null);
    }

    public static long zzv() {
        return zzap.zzg.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgs)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgs)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgs)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgs)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public static boolean zzy() {
        return zzap.zzc.zza(null);
    }

    public final boolean zzd(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zze(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzf(String string) {
        return this.zzd(string, zzap.zzaq);
    }

    @WorkerThread
    final boolean zzg(String string) {
        return this.zzd(string, zzap.zzak);
    }

    @WorkerThread
    final String zzh(String string) {
        zzem<String> zzem2 = zzap.zzal;
        String string2 = string;
        zzx zzx2 = this;
        if (string2 == null) {
            return zzem2.zza(null);
        }
        return zzem2.zza(zzx2.zzb.zza(string2, zzem2.zza()));
    }

    @WorkerThread
    final boolean zzi(String string) {
        return this.zzd(string, zzap.zzar);
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzd(string, zzap.zzat);
    }

    @WorkerThread
    final boolean zzz() {
        if (this.zza == null) {
            this.zza = this.zzb("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzx.zzt();
    }

    @WorkerThread
    final boolean zzk(String string) {
        return this.zzd(string, zzap.zzas);
    }

    @WorkerThread
    final boolean zzl(String string) {
        return this.zzd(string, zzap.zzau);
    }

    @WorkerThread
    final boolean zzm(String string) {
        return this.zzd(string, zzap.zzav);
    }

    @WorkerThread
    final boolean zzn(String string) {
        return this.zzd(string, zzap.zzaw);
    }

    @WorkerThread
    final boolean zzo(String string) {
        return this.zzd(string, zzap.zzax);
    }

    @WorkerThread
    final boolean zzp(String string) {
        return this.zzd(string, zzap.zzbe);
    }
}

