/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzkm;
import java.util.Map;

public final class zzii
extends zze {
    @VisibleForTesting
    protected zzif zza;
    private volatile zzif zzb;
    private zzif zzc;
    private final Map<Activity, zzif> zzd = new ArrayMap();
    private zzif zze;
    private String zzf;

    public zzii(zzga zzga2) {
        super(zzga2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzif zzab() {
        this.zzw();
        ((zzgr)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzii.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzkm.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgr)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgr)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgr)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzif zzif2 = new zzif(string, string2, ((zzgr)this).zzp().zzg());
        this.zzd.put(activity, zzif2);
        this.zza(activity, zzif2, true);
    }

    public final zzif zzac() {
        ((zzgr)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzif zzif2, boolean bl) {
        zzif zzif3;
        zzif zzif4 = zzif3 = this.zzb == null ? this.zzc : this.zzb;
        if (zzif2.zzb == null) {
            zzif2 = new zzif(zzif2.zza, zzii.zza(activity.getClass().getCanonicalName()), zzif2.zzc);
        }
        zzif zzif5 = zzif2;
        this.zzc = this.zzb;
        this.zzb = zzif5;
        ((zzgr)this).zzq().zza(new zzih(this, bl, zzif3, zzif5));
    }

    @WorkerThread
    private final void zza(@NonNull zzif zzif2, boolean bl) {
        ((zzf)this).zze().zza(((zzgr)this).zzm().elapsedRealtime());
        if (((zzf)this).zzk().zza(zzif2.zzd, bl)) {
            zzif2.zzd = false;
        }
    }

    public static void zza(zzif zzif2, Bundle bundle, boolean bl) {
        if (bundle != null && zzif2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzif2.zza != null) {
                bundle.putString("_sn", zzif2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzif2.zzb);
            bundle.putLong("_si", zzif2.zzc);
            return;
        }
        if (bundle != null && zzif2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzif zzif2) {
        ((zzgr)this).zzd();
        zzii zzii2 = this;
        synchronized (zzii2) {
            if (this.zzf == null || this.zzf.equals(string) || zzif2 != null) {
                this.zzf = string;
                this.zze = zzif2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzif zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzif zzif2 = this.zzd.get(activity);
        if (zzif2 == null) {
            String string = zzii.zza(activity.getClass().getCanonicalName());
            zzif2 = new zzif(null, string, ((zzgr)this).zzp().zzg());
            this.zzd.put(activity, zzif2);
        }
        return zzif2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzif zzif2 = new zzif(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzif2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zzif zzif2 = this.zzd(activity);
        this.zza(activity, zzif2, false);
        zzb zzb2 = ((zzf)this).zze();
        long l = ((zzgr)zzb2).zzm().elapsedRealtime();
        ((zzgr)zzb2).zzq().zza(new zzc(zzb2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzif zzif2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgr)this).zzq().zza(new zzik(this, zzif2));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzif zzif2 = this.zzd.get(activity);
        if (zzif2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzif2.zzc);
        bundle2.putString("name", zzif2.zza);
        bundle2.putString("referrer_name", zzif2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzii zzii2, zzif zzif2, boolean bl) {
        zzii2.zza(zzif2, bl);
    }
}

