/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzji;

@VisibleForTesting
public final class zzjb
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzet zzc;
    final /* synthetic */ zzij zza;

    protected zzjb(zzij zzij2) {
        this.zza = zzij2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgr)this.zza).zzd();
        Context context = ((zzgr)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjb zzjb2 = this;
        synchronized (zzjb2) {
            if (this.zzb) {
                ((zzgr)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzgr)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzij.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjb zzjb2 = this;
        synchronized (zzjb2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgr)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzeo zzeo2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzeo2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzeo ? (zzeo)iInterface : new zzeq(iBinder2));
                    ((zzgr)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgr)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgr)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzeo2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgr)this.zza).zzn(), (ServiceConnection)zzij.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzeo2;
                ((zzgr)this.zza).zzq().zza(new zzje(this, (zzeo)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgr)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzgr)this.zza).zzq().zza(new zzjd(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgr)this.zza).zzd();
        Context context = ((zzgr)this.zza).zzn();
        zzjb zzjb2 = this;
        synchronized (zzjb2) {
            if (this.zzb) {
                ((zzgr)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgr)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzet(context, Looper.getMainLooper(), this, this);
            ((zzgr)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjb zzjb2 = this;
        synchronized (zzjb2) {
            try {
                zzeo zzeo2 = (zzeo)this.zzc.getService();
                ((zzgr)this.zza).zzq().zza(new zzjg(this, zzeo2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgr)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzgr)this.zza).zzq().zza(new zzjf(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzew zzew2 = this.zza.zzx.zzd();
        if (zzew2 != null) {
            zzew2.zzi().zza("Service connection failed", connectionResult);
        }
        zzjb zzjb2 = this;
        synchronized (zzjb2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgr)this.zza).zzq().zza(new zzji(this));
    }

    static /* synthetic */ boolean zza(zzjb zzjb2, boolean bl) {
        zzjb2.zzb = false;
        return false;
    }
}

