/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgc
extends zzgz {
    private zzgg zza;
    private zzgg zzb;
    private final PriorityBlockingQueue<zzgd<?>> zzc;
    private final BlockingQueue<zzgd<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzgc(zzgf zzgf2) {
        super(zzgf2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzge(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzge(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgd zzgd2 = new zzgd(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzha)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzgd2.run();
        } else {
            this.zza(zzgd2);
        }
        return zzgd2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgd zzgd2 = new zzgd(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzgd2.run();
        } else {
            this.zza(zzgd2);
        }
        return zzgd2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgd(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzha)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzha)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzha)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgd<?> zzgd2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzgd2);
            if (this.zza == null) {
                this.zza = new zzgg(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzgd zzgd2 = new zzgd(this, runnable, false, "Task exception on network thread");
        zzgc zzgc2 = this;
        Object object = zzgc2.zzg;
        synchronized (object) {
            zzgc2.zzd.add(zzgd2);
            if (zzgc2.zzb == null) {
                zzgc2.zzb = new zzgg(zzgc2, "Measurement Network", zzgc2.zzd);
                zzgc2.zzb.setUncaughtExceptionHandler(zzgc2.zzf);
                zzgc2.zzb.start();
            } else {
                zzgc2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzgc zzgc2) {
        return zzgc2.zzh;
    }

    static /* synthetic */ boolean zzb(zzgc zzgc2) {
        return zzgc2.zzi;
    }

    static /* synthetic */ Object zzc(zzgc zzgc2) {
        return zzgc2.zzg;
    }

    static /* synthetic */ zzgg zzd(zzgc zzgc2) {
        return zzgc2.zza;
    }

    static /* synthetic */ zzgg zza(zzgc zzgc2, zzgg zzgg2) {
        zzgc2.zza = null;
        return null;
    }

    static /* synthetic */ zzgg zze(zzgc zzgc2) {
        return zzgc2.zzb;
    }

    static /* synthetic */ zzgg zzb(zzgc zzgc2, zzgg zzgg2) {
        zzgc2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

