/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;

@VisibleForTesting
public final class zzjk
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzfc zzc;
    final /* synthetic */ zzis zza;

    protected zzjk(zzis zzis2) {
        this.zza = zzis2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzha)this.zza).zzd();
        Context context = ((zzha)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjk zzjk2 = this;
        synchronized (zzjk2) {
            if (this.zzb) {
                ((zzha)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzha)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzis.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjk zzjk2 = this;
        synchronized (zzjk2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzha)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzet zzet2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzet2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzet ? (zzet)iInterface : new zzev(iBinder2));
                    ((zzha)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzha)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzha)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzet2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzha)this.zza).zzn(), (ServiceConnection)zzis.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzet2;
                ((zzha)this.zza).zzq().zza(new zzjj(this, (zzet)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzha)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzha)this.zza).zzq().zza(new zzjm(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzha)this.zza).zzd();
        Context context = ((zzha)this.zza).zzn();
        zzjk zzjk2 = this;
        synchronized (zzjk2) {
            if (this.zzb) {
                ((zzha)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzha)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfc(context, Looper.getMainLooper(), this, this);
            ((zzha)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjk zzjk2 = this;
        synchronized (zzjk2) {
            try {
                zzet zzet2 = (zzet)this.zzc.getService();
                ((zzha)this.zza).zzq().zza(new zzjl(this, zzet2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzha)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzha)this.zza).zzq().zza(new zzjo(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfb zzfb2 = this.zza.zzx.zzd();
        if (zzfb2 != null) {
            zzfb2.zzi().zza("Service connection failed", connectionResult);
        }
        zzjk zzjk2 = this;
        synchronized (zzjk2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzha)this.zza).zzq().zza(new zzjn(this));
    }

    static /* synthetic */ boolean zza(zzjk zzjk2, boolean bl) {
        zzjk2.zzb = false;
        return false;
    }
}

