/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzla;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzft
extends zzhi {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzy;
    public zzfx zzb;
    public final zzfy zzc = new zzfy(this, "last_upload", 0L);
    public final zzfy zzd = new zzfy(this, "last_upload_attempt", 0L);
    public final zzfy zze = new zzfy(this, "backoff", 0L);
    public final zzfy zzf = new zzfy(this, "last_delete_stale", 0L);
    public final zzfy zzg;
    public final zzfy zzh;
    public final zzfy zzi;
    public final zzga zzj;
    private String zzz;
    private boolean zzaa;
    private long zzab;
    public final zzfy zzk = new zzfy(this, "time_before_start", 10000L);
    public final zzfy zzl = new zzfy(this, "session_timeout", 1800000L);
    public final zzfv zzm = new zzfv(this, "start_new_session", true);
    public final zzga zzn;
    public final zzfv zzo;
    public final zzfv zzp;
    public final zzfy zzq = new zzfy(this, "last_pause_time", 0L);
    public final zzfy zzr = new zzfy(this, "time_active", 0L);
    public boolean zzs;
    public zzfv zzt;
    public zzfv zzu;
    public zzfy zzv;
    public final zzga zzw;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzz != null && l < this.zzab) {
            return new Pair((Object)this.zzz, (Object)this.zzaa);
        }
        String string2 = string;
        this.zzab = l + this.zzt().zza(string2, zzap.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzz = info.getId();
                this.zzaa = info.isLimitAdTrackingEnabled();
            }
            if (this.zzz == null) {
                this.zzz = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzz = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzz, (Object)this.zzaa);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzla.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzft(zzgo zzgo2) {
        super(zzgo2);
        this.zzn = new zzga(this, "non_personalized_ads", null);
        this.zzo = new zzfv(this, "use_dynamite_api", false);
        this.zzp = new zzfv(this, "allow_remote_dynamite", false);
        this.zzg = new zzfy(this, "midnight_offset", 0L);
        this.zzh = new zzfy(this, "first_open_time", 0L);
        this.zzi = new zzfy(this, "app_install_time", 0L);
        this.zzj = new zzga(this, "app_instance_id", null);
        this.zzt = new zzfv(this, "app_backgrounded", false);
        this.zzu = new zzfv(this, "deep_link_retrieval_complete", false);
        this.zzv = new zzfy(this, "deep_link_retrieval_attempts", 0L);
        this.zzw = new zzga(this, "firebase_feature_rollouts", null);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzy = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzs = this.zzy.getBoolean("has_been_opened", false);
        if (!this.zzs) {
            SharedPreferences.Editor editor = this.zzy.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfx(this, "health_monitor", Math.max(0L, (Long)zzap.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzg() {
        this.zzd();
        this.zzaa();
        return this.zzy;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzg().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzi() {
        this.zzd();
        return this.zzg().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzj() {
        this.zzd();
        if (!this.zzg().contains("use_service")) {
            return null;
        }
        return this.zzg().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzk() {
        this.zzd();
        Boolean bl = this.zzv();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zzb(bl);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final Boolean zzv() {
        this.zzd();
        if (this.zzg().contains("measurement_enabled")) {
            return this.zzg().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzw() {
        this.zzd();
        String string = this.zzg().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzg().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzc(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzy.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzq.zza();
    }
}

