/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhi;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgh
extends zzhi {
    private zzgl zza;
    private zzgl zzb;
    private final PriorityBlockingQueue<zzgm<?>> zzc;
    private final BlockingQueue<zzgm<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzgh(zzgo zzgo2) {
        super(zzgo2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzgj(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzgj(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgm zzgm2 = new zzgm(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzhf)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzgm2.run();
        } else {
            this.zza(zzgm2);
        }
        return zzgm2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgm zzgm2 = new zzgm(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzgm2.run();
        } else {
            this.zza(zzgm2);
        }
        return zzgm2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgm(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzhf)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzhf)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzhf)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgm<?> zzgm2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzgm2);
            if (this.zza == null) {
                this.zza = new zzgl(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzgm zzgm2 = new zzgm(this, runnable, false, "Task exception on network thread");
        zzgh zzgh2 = this;
        Object object = zzgh2.zzg;
        synchronized (object) {
            zzgh2.zzd.add(zzgm2);
            if (zzgh2.zzb == null) {
                zzgh2.zzb = new zzgl(zzgh2, "Measurement Network", zzgh2.zzd);
                zzgh2.zzb.setUncaughtExceptionHandler(zzgh2.zzf);
                zzgh2.zzb.start();
            } else {
                zzgh2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzgh zzgh2) {
        return zzgh2.zzh;
    }

    static /* synthetic */ boolean zzb(zzgh zzgh2) {
        return zzgh2.zzi;
    }

    static /* synthetic */ Object zzc(zzgh zzgh2) {
        return zzgh2.zzg;
    }

    static /* synthetic */ zzgl zzd(zzgh zzgh2) {
        return zzgh2.zza;
    }

    static /* synthetic */ zzgl zza(zzgh zzgh2, zzgl zzgl2) {
        zzgh2.zza = null;
        return null;
    }

    static /* synthetic */ zzgl zze(zzgh zzgh2) {
        return zzgh2.zzb;
    }

    static /* synthetic */ zzgl zzb(zzgh zzgh2, zzgl zzgl2) {
        zzgh2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

