/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjw;

@VisibleForTesting
public final class zzjp
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzfh zzc;
    final /* synthetic */ zzix zza;

    protected zzjp(zzix zzix2) {
        this.zza = zzix2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzhf)this.zza).zzd();
        Context context = ((zzhf)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            if (this.zzb) {
                ((zzhf)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzhf)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzix.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzhf)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzfc zzfc2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfc2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfc ? (zzfc)iInterface : new zzfe(iBinder2));
                    ((zzhf)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzhf)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzhf)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfc2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzhf)this.zza).zzn(), (ServiceConnection)zzix.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfc2;
                ((zzhf)this.zza).zzq().zza(new zzjs(this, (zzfc)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzhf)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzhf)this.zza).zzq().zza(new zzjr(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzhf)this.zza).zzd();
        Context context = ((zzhf)this.zza).zzn();
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            if (this.zzb) {
                ((zzhf)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzhf)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfh(context, Looper.getMainLooper(), this, this);
            ((zzhf)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            try {
                zzfc zzfc2 = (zzfc)this.zzc.getService();
                ((zzhf)this.zza).zzq().zza(new zzju(this, zzfc2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzhf)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzhf)this.zza).zzq().zza(new zzjt(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfk zzfk2 = this.zza.zzx.zzd();
        if (zzfk2 != null) {
            zzfk2.zzi().zza("Service connection failed", connectionResult);
        }
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzhf)this.zza).zzq().zza(new zzjw(this));
    }

    static /* synthetic */ boolean zza(zzjp zzjp2, boolean bl) {
        zzjp2.zzb = false;
        return false;
    }
}

