/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzw;

public final class zzgg {
    private final zzgh zza;

    public zzgg(zzgh zzgh2) {
        Preconditions.checkNotNull((Object)zzgh2);
        this.zza = zzgh2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void zza(Context context, Intent intent) {
        zzgq zzgq2 = zzgq.zza(context, null);
        zzfj zzfj2 = zzgq2.zzr();
        if (intent == null) {
            zzfj2.zzi().zza("Receiver called with null intent");
            return;
        }
        zzw zzw2 = zzgq2.zzu();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzfj2.zzx().zza("Device receiver got", string);
        } else {
            zzfj2.zzx().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzfj2.zzx().zza("Starting wakeful intent.");
            this.zza.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzgq2.zzq().zza(new zzgf(this, zzgq2, zzfj2));
            }
            catch (Exception exception) {
                zzfj2.zzi().zza("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zza.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzfj2.zzx().zza("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzfj2.zzv().zza("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzgq2.zzi().zza(uri);
            if (bundle == null) {
                zzfj2.zzx().zza("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzfj2.zzi().zza("Install referrer is missing timestamp");
                }
                zzgq2.zzq().zza(new zzgi(this, zzgq2, l, bundle, context, zzfj2, pendingResult));
            }
        }
    }
}

