/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zziz
extends zze {
    private final zzjr zza;
    private zzfb zzb;
    private volatile Boolean zzc;
    private final zzaf zzd;
    private final zzkl zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaf zzg;

    protected zziz(zzgq zzgq2) {
        super(zzgq2);
        this.zze = new zzkl(zzgq2.zzm());
        this.zza = new zzjr(this);
        this.zzd = new zzjc(this, zzgq2);
        this.zzg = new zzjj(this, zzgq2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzhh)this).zzd();
        this.zzw();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzac() {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(true);
        this.zza(new zzjm(this, zzm2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzfb zzfb2, AbstractSafeParcelable abstractSafeParcelable, zzm zzm2) {
        ((zzhh)this).zzd();
        ((zzhh)this).zzb();
        this.zzw();
        boolean bl = this.zzaj();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzf)this).zzj().zza(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzan) {
                    try {
                        zzfb2.zza((zzan)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhh)this).zzr().zzf().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkz) {
                    try {
                        zzfb2.zza((zzkz)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhh)this).zzr().zzf().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzv) {
                    try {
                        zzfb2.zza((zzv)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhh)this).zzr().zzf().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzhh)this).zzr().zzf().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzan zzan2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzan2));
        ((zzhh)this).zzd();
        this.zzw();
        boolean bl = this.zzaj();
        boolean bl2 = bl && ((zzf)this).zzj().zza(zzan2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzjl(this, bl, bl2, zzan2, zzm2, string));
    }

    @WorkerThread
    protected final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)((Object)zzv2));
        ((zzhh)this).zzd();
        this.zzw();
        zzw zzw2 = ((zzhh)this).zzu();
        boolean bl = true;
        boolean bl2 = true && ((zzf)this).zzj().zza(zzv2);
        zzv zzv3 = new zzv(zzv2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzjo(this, bl, bl2, zzv3, zzm2, zzv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzv>> atomicReference, String string, String string2, String string3) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjn(this, atomicReference, string, string2, string3, zzm2));
    }

    @WorkerThread
    protected final void zza(zzn zzn2, String string, String string2) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjq(this, string, string2, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkz>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjp(this, atomicReference, string, string2, string3, bl, zzm2));
    }

    @WorkerThread
    protected final void zza(zzn zzn2, String string, String string2, boolean bl) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjs(this, string, string2, bl, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zza(zzkz zzkz2) {
        ((zzhh)this).zzd();
        this.zzw();
        boolean bl = this.zzaj() && ((zzf)this).zzj().zza(zzkz2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzjb(this, bl, zzkz2, zzm2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkz>> atomicReference, boolean bl) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzje(this, atomicReference, zzm2, bl));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzhh)this).zzd();
        ((zzhh)this).zzb();
        this.zzw();
        zzm zzm2 = this.zza(false);
        if (this.zzaj()) {
            ((zzf)this).zzj().zzab();
        }
        this.zza(new zzjd(this, zzm2));
    }

    private final boolean zzaj() {
        zzw zzw2 = ((zzhh)this).zzu();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjg(this, atomicReference, zzm2));
    }

    @WorkerThread
    public final void zza(zzn zzn2) {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjf(this, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zzae() {
        ((zzhh)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(true);
        boolean bl = ((zzhh)this).zzt().zza(zzap.zzbz);
        if (bl) {
            ((zzf)this).zzj().zzac();
        }
        this.zza(new zzji(this, zzm2, bl));
    }

    @WorkerThread
    protected final void zza(zziv zziv2) {
        ((zzhh)this).zzd();
        this.zzw();
        this.zza(new zzjh(this, zziv2));
    }

    @WorkerThread
    private final void zzak() {
        ((zzhh)this).zzd();
        this.zze.zza();
        this.zzd.zza((Long)zzap.zzai.zza(null));
    }

    @WorkerThread
    final void zzaf() {
        ((zzhh)this).zzd();
        this.zzw();
        if (this.zzab()) {
            return;
        }
        if (this.zzal()) {
            this.zza.zzb();
            return;
        }
        if (!((zzhh)this).zzt().zzy()) {
            Intent intent;
            zziz zziz2 = this;
            zzw zzw2 = ((zzhh)zziz2).zzu();
            PackageManager packageManager = ((zzhh)zziz2).zzn().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzhh)zziz2).zzn(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzw2 = ((zzhh)this).zzu();
                intent2.setComponent(new ComponentName(((zzhh)this).zzn(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzhh)this).zzr().zzf().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzag() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzal() {
        ((zzhh)this).zzd();
        this.zzw();
        if (this.zzc == null) {
            boolean bl;
            zziz zziz2 = this;
            ((zzhh)zziz2).zzd();
            zziz2.zzw();
            Boolean bl2 = ((zzhh)zziz2).zzs().zzj();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzw zzw2 = ((zzhh)zziz2).zzu();
                if (((zzf)zziz2).zzg().zzag() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzhh)zziz2).zzr().zzx().zza("Checking service availability");
                    int n = ((zzhh)zziz2).zzp().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzhh)zziz2).zzr().zzx().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzhh)zziz2).zzr().zzx().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzhh)zziz2).zzr().zzi().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzhh)zziz2).zzr().zzw().zza("Service container out of date");
                            if (((zzhh)zziz2).zzp().zzj() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzhh)zziz2).zzr().zzi().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzhh)zziz2).zzr().zzi().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzhh)zziz2).zzr().zzi().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzhh)zziz2).zzt().zzy()) {
                    ((zzhh)zziz2).zzr().zzf().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzhh)zziz2).zzs().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzfb zzfb2) {
        ((zzhh)this).zzd();
        Preconditions.checkNotNull((Object)zzfb2);
        this.zzb = zzfb2;
        this.zzak();
        this.zzan();
    }

    @WorkerThread
    public final void zzah() {
        ((zzhh)this).zzd();
        this.zzw();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzhh)this).zzn(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzhh)this).zzd();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzhh)this).zzr().zzx().zza("Disconnected from device MeasurementService", componentName);
            zziz zziz2 = this;
            ((zzhh)zziz2).zzd();
            zziz2.zzaf();
        }
    }

    @WorkerThread
    private final void zzam() {
        ((zzhh)this).zzd();
        if (!this.zzab()) {
            return;
        }
        ((zzhh)this).zzr().zzx().zza("Inactivity, disconnecting from the service");
        this.zzah();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzhh)this).zzd();
        if (this.zzab()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzhh)this).zzr().zzf().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzaf();
    }

    @WorkerThread
    private final void zzan() {
        ((zzhh)this).zzd();
        ((zzhh)this).zzr().zzx().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzhh)this).zzr().zzf().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzm zza(boolean bl) {
        zzw zzw2 = ((zzhh)this).zzu();
        return ((zzf)this).zzg().zza(bl ? ((zzhh)this).zzr().zzy() : null);
    }

    @WorkerThread
    public final void zza(zzn zzn2, zzan zzan2, String string) {
        ((zzhh)this).zzd();
        this.zzw();
        int n = ((zzhh)this).zzp().zza(12451000);
        if (n != 0) {
            ((zzhh)this).zzr().zzi().zza("Not bundling data. Service unavailable or out of date");
            ((zzhh)this).zzp().zza(zzn2, new byte[0]);
            return;
        }
        this.zza(new zzjk(this, zzan2, string, zzn2));
    }

    @WorkerThread
    final boolean zzai() {
        ((zzhh)this).zzd();
        this.zzw();
        if (!this.zzal()) {
            return true;
        }
        return ((zzhh)this).zzp().zzj() >= 200900;
    }

    static /* synthetic */ zzjr zza(zziz zziz2) {
        return zziz2.zza;
    }

    static /* synthetic */ void zza(zziz zziz2, ComponentName componentName) {
        zziz2.zza(componentName);
    }

    static /* synthetic */ zzfb zza(zziz zziz2, zzfb zzfb2) {
        zziz2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zziz zziz2) {
        zziz2.zzan();
    }

    static /* synthetic */ void zzc(zziz zziz2) {
        zziz2.zzam();
    }

    static /* synthetic */ zzfb zzd(zziz zziz2) {
        return zziz2.zzb;
    }

    static /* synthetic */ void zze(zziz zziz2) {
        zziz2.zzak();
    }
}

