/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;

public final class zzeo
extends zzg {
    private final zzer zza = new zzer(this, ((zzgr)this).zzn(), "google_app_measurement_local.db");
    private boolean zzb;

    zzeo(zzfw zzfw2) {
        super(zzfw2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final void zzab() {
        ((zzgr)this).zzb();
        ((zzgr)this).zzd();
        try {
            SQLiteDatabase sQLiteDatabase = this.zzae();
            int n = 0 + sQLiteDatabase.delete("messages", null, null);
            if (n > 0) {
                ((zzgr)this).zzr().zzx().zza("Reset local analytics data. records", n);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzgr)this).zzr().zzf().zza("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        ((zzgr)this).zzb();
        ((zzgr)this).zzd();
        if (this.zzb) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzgr)this).zzr().zzx().zza("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzae();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzgr)this).zzr().zzf().zza("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzgr)this).zzr().zzf().zza("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzb = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzgr)this).zzr().zzf().zza("Error writing entry; local database full", (Object)sQLiteFullException);
                    this.zzb = true;
                    break block20;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzgr)this).zzr().zzf().zza("Error writing entry to local database", (Object)sQLiteException);
                    this.zzb = true;
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzao zzao2) {
        Parcel parcel = Parcel.obtain();
        zzao2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzgr)this).zzr().zzg().zza("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zzkh zzkh2) {
        Parcel parcel = Parcel.obtain();
        zzkh2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzgr)this).zzr().zzg().zza("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    public final boolean zza(zzw zzw2) {
        ((zzgr)this).zzp();
        byte[] byArray = zzkm.zza((Parcelable)zzw2);
        if (byArray.length > 131072) {
            ((zzgr)this).zzr().zzg().zza("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<AbstractSafeParcelable> zza(int n) {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        if (this.zzb) {
            return null;
        }
        ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
        if (!this.zzaf()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block43: {
                if (n3 >= 5) {
                    ((zzgr)this).zzr().zzi().zza("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzae();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        long l = zzeo.zza(sQLiteDatabase);
                        String string = null;
                        String[] stringArray = null;
                        if (l != -1L) {
                            string = "rowid<?";
                            stringArray = new String[]{String.valueOf(l)};
                        }
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, string, stringArray, null, null, "rowid asc", Integer.toString(100));
                        long l2 = -1L;
                        while (cursor.moveToNext()) {
                            AbstractSafeParcelable abstractSafeParcelable;
                            Parcel parcel;
                            l2 = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzao)((Object)zzao.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzgr)this).zzr().zzf().zza("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzkh)((Object)zzkh.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzgr)this).zzr().zzf().zza("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzw)((Object)zzw.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzgr)this).zzr().zzf().zza("Failed to load conditional user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 3) {
                                ((zzgr)this).zzr().zzi().zza("Skipping app launch break");
                                continue;
                            }
                            ((zzgr)this).zzr().zzf().zza("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l2)}) < arrayList.size()) {
                            ((zzgr)this).zzr().zzf().zza("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzb = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzgr)this).zzr().zzf().zza("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzb = true;
                    break block43;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block43;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzgr)this).zzr().zzf().zza("Error reading entries from local database", (Object)sQLiteException);
                    this.zzb = true;
                    break block43;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zza(3, new byte[0]);
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        if (this.zzb) {
            return false;
        }
        if (!this.zzaf()) {
            return false;
        }
        int n = 5;
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                sQLiteDatabase = this.zzae();
                if (sQLiteDatabase == null) {
                    this.zzb = true;
                    return false;
                }
                sQLiteDatabase.beginTransaction();
                sQLiteDatabase.delete("messages", "type == ?", new String[]{Integer.toString(3)});
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                return true;
            }
        }
        ((zzgr)this).zzr().zzi().zza("Error deleting app launch break from local database in reasonable time");
        return false;
    }

    private static long zza(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor;
        block4: {
            long l;
            block5: {
                cursor = null;
                try {
                    cursor = sQLiteDatabase.query("messages", new String[]{"rowid"}, "type=?", new String[]{"3"}, null, null, "rowid desc", "1");
                    if (!cursor.moveToFirst()) break block4;
                    l = cursor.getLong(0);
                    if (cursor == null) break block5;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return l;
        }
        if (cursor != null) {
            cursor.close();
        }
        return -1L;
    }

    @VisibleForTesting
    @WorkerThread
    private final SQLiteDatabase zzae() throws SQLiteException {
        if (this.zzb) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zza.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzb = true;
            return null;
        }
        return sQLiteDatabase;
    }

    @VisibleForTesting
    private final boolean zzaf() {
        return ((zzgr)this).zzn().getDatabasePath("google_app_measurement_local.db").exists();
    }
}

