/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzkm;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfe
extends zzgq {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzaa;
    public zzfl zzb;
    public final zzfi zzc = new zzfi(this, "last_upload", 0L);
    public final zzfi zzd = new zzfi(this, "last_upload_attempt", 0L);
    public final zzfi zze = new zzfi(this, "backoff", 0L);
    public final zzfi zzf = new zzfi(this, "last_delete_stale", 0L);
    public final zzfi zzg;
    public final zzfi zzh;
    public final zzfi zzi;
    public final zzfk zzj;
    private String zzab;
    private boolean zzac;
    private long zzad;
    public final zzfi zzk = new zzfi(this, "time_before_start", 10000L);
    public final zzfi zzl = new zzfi(this, "session_timeout", 1800000L);
    public final zzfg zzm = new zzfg(this, "start_new_session", true);
    public final zzfk zzn;
    public final zzfg zzo;
    public final zzfg zzp;
    public final zzfi zzq = new zzfi(this, "last_pause_time", 0L);
    public boolean zzr;
    public zzfg zzs;
    public zzfg zzt;
    public zzfi zzu;
    public final zzfk zzv;
    public final zzfk zzw;
    public final zzfi zzx;
    public final zzfj zzy;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzab != null && l < this.zzad) {
            return new Pair((Object)this.zzab, (Object)this.zzac);
        }
        String string2 = string;
        this.zzad = l + this.zzt().zza(string2, zzaq.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzab = info.getId();
                this.zzac = info.isLimitAdTrackingEnabled();
            }
            if (this.zzab == null) {
                this.zzab = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzab = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzab, (Object)this.zzac);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzkm.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfe(zzfw zzfw2) {
        super(zzfw2);
        this.zzn = new zzfk(this, "non_personalized_ads", null);
        this.zzo = new zzfg(this, "use_dynamite_api", false);
        this.zzp = new zzfg(this, "allow_remote_dynamite", false);
        this.zzg = new zzfi(this, "midnight_offset", 0L);
        this.zzh = new zzfi(this, "first_open_time", 0L);
        this.zzi = new zzfi(this, "app_install_time", 0L);
        this.zzj = new zzfk(this, "app_instance_id", null);
        this.zzs = new zzfg(this, "app_backgrounded", false);
        this.zzt = new zzfg(this, "deep_link_retrieval_complete", false);
        this.zzu = new zzfi(this, "deep_link_retrieval_attempts", 0L);
        this.zzv = new zzfk(this, "firebase_feature_rollouts", null);
        this.zzw = new zzfk(this, "deferred_attribution_cache", null);
        this.zzx = new zzfi(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzy = new zzfj(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzaa = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzr = this.zzaa.getBoolean("has_been_opened", false);
        if (!this.zzr) {
            SharedPreferences.Editor editor = this.zzaa.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfl(this, "health_monitor", Math.max(0L, (Long)zzaq.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzg() {
        this.zzd();
        this.zzaa();
        return this.zzaa;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzg().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzi() {
        this.zzd();
        return this.zzg().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzj() {
        this.zzd();
        if (!this.zzg().contains("use_service")) {
            return null;
        }
        return this.zzg().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzk() {
        this.zzd();
        Boolean bl = this.zzv();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zzb(bl);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final Boolean zzv() {
        this.zzd();
        if (this.zzg().contains("measurement_enabled")) {
            return this.zzg().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzw() {
        this.zzd();
        String string = this.zzg().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzg().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzc(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzaa.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzq.zza();
    }
}

