/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzft
extends zzgq {
    private zzfx zza;
    private zzfx zzb;
    private final PriorityBlockingQueue<zzfu<?>> zzc;
    private final BlockingQueue<zzfu<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzft(zzfw zzfw2) {
        super(zzfw2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfv(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfv(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfu zzfu2 = new zzfu(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgr)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzfu2.run();
        } else {
            this.zza(zzfu2);
        }
        return zzfu2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfu zzfu2 = new zzfu(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfu2.run();
        } else {
            this.zza(zzfu2);
        }
        return zzfu2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfu(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgr)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgr)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgr)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfu<?> zzfu2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfu2);
            if (this.zza == null) {
                this.zza = new zzfx(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzfu zzfu2 = new zzfu(this, runnable, false, "Task exception on network thread");
        zzft zzft2 = this;
        Object object = zzft2.zzg;
        synchronized (object) {
            zzft2.zzd.add(zzfu2);
            if (zzft2.zzb == null) {
                zzft2.zzb = new zzfx(zzft2, "Measurement Network", zzft2.zzd);
                zzft2.zzb.setUncaughtExceptionHandler(zzft2.zzf);
                zzft2.zzb.start();
            } else {
                zzft2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzft zzft2) {
        return zzft2.zzh;
    }

    static /* synthetic */ boolean zzb(zzft zzft2) {
        return zzft2.zzi;
    }

    static /* synthetic */ Object zzc(zzft zzft2) {
        return zzft2.zzg;
    }

    static /* synthetic */ zzfx zzd(zzft zzft2) {
        return zzft2.zza;
    }

    static /* synthetic */ zzfx zza(zzft zzft2, zzfx zzfx2) {
        zzft2.zza = null;
        return null;
    }

    static /* synthetic */ zzfx zze(zzft zzft2) {
        return zzft2.zzb;
    }

    static /* synthetic */ zzfx zzb(zzft zzft2, zzfx zzfx2) {
        zzft2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

