/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcn;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfw
implements zzgt {
    private static volatile zzfw zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzx zzh;
    private final zzy zzi;
    private final zzfe zzj;
    private final zzes zzk;
    private final zzft zzl;
    private final zzjm zzm;
    private final zzkm zzn;
    private final zzeq zzo;
    private final Clock zzp;
    private final zzig zzq;
    private final zzhb zzr;
    private final zza zzs;
    private final zzib zzt;
    private zzeo zzu;
    private zzil zzv;
    private zzai zzw;
    private zzep zzx;
    private zzfn zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private int zzaf;
    private AtomicInteger zzag = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzfw(zzgy zzgy2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgy2);
        Object object2 = zzgy2.zza;
        zzei.zza = this.zzh = new zzx((Context)object2);
        this.zzc = zzgy2.zza;
        this.zzd = zzgy2.zzb;
        this.zze = zzgy2.zzc;
        this.zzf = zzgy2.zzd;
        this.zzg = zzgy2.zzh;
        this.zzac = zzgy2.zze;
        com.google.android.gms.internal.measurement.zzx zzx2 = zzgy2.zzg;
        if (zzx2 != null && zzx2.zzg != null) {
            object = zzx2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzx2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzcn.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzgy2.zzi != null ? zzgy2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzy((zzfw)object2);
        object2 = this;
        object = new zzfe((zzfw)object2);
        ((zzgq)object).zzab();
        this.zzj = object;
        object2 = this;
        zzes zzes2 = new zzes((zzfw)object2);
        zzes2.zzab();
        this.zzk = zzes2;
        object2 = this;
        zzkm zzkm2 = new zzkm((zzfw)object2);
        zzkm2.zzab();
        this.zzn = zzkm2;
        object2 = this;
        zzeq zzeq2 = new zzeq((zzfw)object2);
        zzeq2.zzab();
        this.zzo = zzeq2;
        object2 = this;
        this.zzs = new zza((zzfw)object2);
        object2 = this;
        zzig zzig2 = new zzig((zzfw)object2);
        zzig2.zzx();
        this.zzq = zzig2;
        object2 = this;
        zzhb zzhb2 = new zzhb((zzfw)object2);
        zzhb2.zzx();
        this.zzr = zzhb2;
        object2 = this;
        zzjm zzjm2 = new zzjm((zzfw)object2);
        zzjm2.zzx();
        this.zzm = zzjm2;
        object2 = this;
        zzib zzib2 = new zzib((zzfw)object2);
        zzib2.zzab();
        this.zzt = zzib2;
        object2 = this;
        zzft zzft2 = new zzft((zzfw)object2);
        zzft2.zzab();
        this.zzl = zzft2;
        boolean bl = zzgy2.zzg != null && zzgy2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzx zzx3 = ((zzfw)object2).zzh;
        if (((zzfw)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhb zzhb3 = ((zzfw)object2).zzh();
            if (((zzgr)zzhb3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgr)zzhb3).zzn().getApplicationContext();
                if (zzhb3.zza == null) {
                    zzhb3.zza = new zzhw(zzhb3, null);
                }
                if (bl3) {
                    zzhw zzhw2 = zzhb3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhw2);
                    zzhw2 = zzhb3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhw2);
                    ((zzgr)zzhb3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfw)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzfy(this, zzgy2));
    }

    @WorkerThread
    private final void zza(zzgy zzgy2) {
        ((zzgr)this.zzq()).zzd();
        Object object = this;
        zzai zzai2 = new zzai((zzfw)object);
        zzai2.zzab();
        this.zzw = zzai2;
        zzfw zzfw2 = this;
        object = zzgy2;
        zzep zzep2 = new zzep(zzfw2, ((zzgy)object).zzf);
        zzep2.zzx();
        this.zzx = zzep2;
        object = this;
        zzeo zzeo2 = new zzeo((zzfw)object);
        zzeo2.zzx();
        this.zzu = zzeo2;
        object = this;
        zzil zzil2 = new zzil((zzfw)object);
        zzil2.zzx();
        this.zzv = zzil2;
        this.zzn.zzac();
        this.zzj.zzac();
        object = this;
        this.zzy = new zzfn((zzfw)object);
        this.zzx.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzi.zzf());
        zzx zzx2 = this.zzh;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzx2 = this.zzh;
        String string = zzep2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzeu zzeu2;
            if (this.zzi().zzf(string)) {
                zzeu2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzeu2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzeu2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzaf != this.zzag.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzaf, this.zzag.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza() {
        zzx zzx2;
        ((zzgr)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zza);
            this.zzc().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzaq.zzcp)) {
            zzx2 = this.zzh;
            this.zzh().zzb.zzb();
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzx2 = this.zzh;
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzy()) {
                    if (!zzfo.zza(this.zzc)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkm.zza(this.zzc, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzx2 = this.zzh;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzkm.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzv.zzah();
                    this.zzv.zzaf();
                    this.zzc().zzh.zza(this.zza);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzx2 = this.zzh;
            if (zzjx.zzb() && this.zzi.zza(zzaq.zzbv) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzv.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzv.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzi.zzh()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzi.zza(zzaq.zzaz));
        this.zzc().zzp.zza(this.zzi.zza(zzaq.zzba));
    }

    @Override
    public final zzx zzu() {
        return this.zzh;
    }

    public final zzy zzb() {
        return this.zzi;
    }

    public final zzfe zzc() {
        zzfw.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzes zzr() {
        zzfw.zzb(this.zzk);
        return this.zzk;
    }

    public final zzes zzd() {
        if (this.zzk != null && this.zzk.zzz()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzft zzq() {
        zzfw.zzb(this.zzl);
        return this.zzl;
    }

    public final zzjm zze() {
        zzfw.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfn zzf() {
        return this.zzy;
    }

    final zzft zzg() {
        return this.zzl;
    }

    public final zzhb zzh() {
        zzfw.zzb(this.zzr);
        return this.zzr;
    }

    public final zzkm zzi() {
        zzfw.zza(this.zzn);
        return this.zzn;
    }

    public final zzeq zzj() {
        zzfw.zza(this.zzo);
        return this.zzo;
    }

    public final zzeo zzk() {
        zzfw.zzb(this.zzu);
        return this.zzu;
    }

    private final zzib zzai() {
        zzfw.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzn() {
        return this.zzc;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzo() {
        return this.zzd;
    }

    public final String zzp() {
        return this.zze;
    }

    public final String zzs() {
        return this.zzf;
    }

    public final boolean zzt() {
        return this.zzg;
    }

    @Override
    public final Clock zzm() {
        return this.zzp;
    }

    public final zzig zzv() {
        zzfw.zzb(this.zzq);
        return this.zzq;
    }

    public final zzil zzw() {
        zzfw.zzb(this.zzv);
        return this.zzv;
    }

    public final zzai zzx() {
        zzfw.zzb(this.zzw);
        return this.zzw;
    }

    public final zzep zzy() {
        zzfw.zzb(this.zzx);
        return this.zzx;
    }

    public final zza zzz() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @VisibleForTesting
    public static zzfw zza(Context context, String string, String string2, Bundle bundle) {
        return zzfw.zza(context, new com.google.android.gms.internal.measurement.zzx(0L, 0L, true, null, null, null, bundle), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfw zza(Context context, com.google.android.gms.internal.measurement.zzx zzx2, Long l) {
        if (zzx2 != null && (zzx2.zze == null || zzx2.zzf == null)) {
            zzx2 = new com.google.android.gms.internal.measurement.zzx(zzx2.zza, zzx2.zzb, zzx2.zzc, zzx2.zzd, null, null, zzx2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzfw> clazz = zzfw.class;
            synchronized (zzfw.class) {
                if (zzb == null) {
                    zzgy zzgy2 = new zzgy(context, zzx2, l);
                    zzb = new zzfw(zzgy2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzx2 != null && zzx2.zzg != null && zzx2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzx2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgq zzgq2) {
        if (zzgq2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgq2.zzz()) {
            String string = String.valueOf(zzgq2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzv()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgr zzgr2) {
        if (zzgr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac() == 0;
    }

    @WorkerThread
    public final int zzac() {
        ((zzgr)this.zzq()).zzd();
        if (this.zzi.zzh()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzy zzy2 = this.zzi;
        zzx zzx2 = ((zzgr)zzy2).zzu();
        Boolean bl2 = zzy2.zzd("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzaq.zzas) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final void zzad() {
        zzx zzx2 = this.zzh;
    }

    final void zzae() {
        zzx zzx2 = this.zzh;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgq zzgq2) {
        ++this.zzaf;
    }

    final void zza(zzg zzg2) {
        ++this.zzaf;
    }

    final void zzaf() {
        this.zzag.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgr)this.zzq()).zzd();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            zzx zzx2 = this.zzh;
            this.zzaa = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzy() || zzfo.zza(this.zzc) && zzkm.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgr)this.zzq()).zzd();
        zzfw.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzi.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgr)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzu.zza() - 1L);
        zzfz zzfz2 = new zzfz(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzib zzib2 = this.zzai();
        ((zzgr)zzib2).zzd();
        zzib2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfz2);
        ((zzgr)zzib2).zzq().zzb(new zzid(zzib2, string2, uRL2, null, null, zzfz2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfw zzfw2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfw2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfw2.zzc().zzt.zza(true);
        if (byArray2.length == 0) {
            zzfw2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzfw2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkm zzkm2 = zzfw2.zzi();
            ((zzgr)zzkm2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgr)zzkm2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfw2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfw2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkm2 = zzfw2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkm2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgr)zzkm2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfw2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfw zzfw2, zzgy zzgy2) {
        zzfw2.zza(zzgy2);
    }
}

