/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzkm;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzig
extends zzg {
    @VisibleForTesting
    protected zzih zza;
    private volatile zzih zzb;
    private zzih zzc;
    private final Map<Activity, zzih> zzd = new ConcurrentHashMap<Activity, zzih>();
    private zzih zze;
    private String zzf;

    public zzig(zzfw zzfw2) {
        super(zzfw2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzih zzab() {
        this.zzw();
        ((zzgr)this).zzd();
        return this.zza;
    }

    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzgr)this).zzt().zzj().booleanValue()) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        if (this.zzb == null) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzig.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = zzkm.zzc(this.zzb.zzb, string2);
        boolean bl2 = zzkm.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgr)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgr)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgr)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgr)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzih zzih2 = new zzih(string, string2, ((zzgr)this).zzp().zzg());
        this.zzd.put(activity, zzih2);
        this.zza(activity, zzih2, true);
    }

    public final zzih zzac() {
        ((zzgr)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzih zzih2, boolean bl) {
        zzih zzih3;
        zzih zzih4;
        zzih zzih5 = zzih4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzih2.zzb == null) {
            zzih3 = activity != null ? zzig.zza(activity.getClass().getCanonicalName()) : null;
            zzih2 = new zzih(zzih2.zza, (String)((Object)zzih3), zzih2.zzc);
        }
        zzih3 = zzih2;
        this.zzc = this.zzb;
        this.zzb = zzih3;
        long l = ((zzgr)this).zzm().elapsedRealtime();
        ((zzgr)this).zzq().zza(new zzij(this, bl, l, zzih4, zzih3));
    }

    @WorkerThread
    private final void zza(zzih zzih2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zze().zza(((zzgr)this).zzm().elapsedRealtime());
        boolean bl3 = bl2 = zzih2 != null && zzih2.zzd;
        if (((zzd)this).zzk().zza(bl2, bl, l) && zzih2 != null) {
            zzih2.zzd = false;
        }
    }

    public static void zza(zzih zzih2, Bundle bundle, boolean bl) {
        if (bundle != null && zzih2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzih2.zza != null) {
                bundle.putString("_sn", zzih2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzih2.zzb != null) {
                bundle.putString("_sc", zzih2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzih2.zzc);
            return;
        }
        if (bundle != null && zzih2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzih zzih2) {
        ((zzgr)this).zzd();
        zzig zzig2 = this;
        synchronized (zzig2) {
            if (this.zzf == null || this.zzf.equals(string) || zzih2 != null) {
                this.zzf = string;
                this.zze = zzih2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzih zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzih zzih2 = this.zzd.get(activity);
        if (zzih2 == null) {
            String string = zzig.zza(activity.getClass().getCanonicalName());
            zzih2 = new zzih(null, string, ((zzgr)this).zzp().zzg());
            this.zzd.put(activity, zzih2);
        }
        return zzih2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (!((zzgr)this).zzt().zzj().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzih zzih2 = new zzih(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzih2);
    }

    @MainThread
    public final void zza(Activity activity) {
        if (!((zzgr)this).zzt().zzj().booleanValue()) {
            return;
        }
        zzih zzih2 = this.zzd(activity);
        this.zza(activity, zzih2, false);
        zza zza2 = ((zzd)this).zze();
        long l = ((zzgr)zza2).zzm().elapsedRealtime();
        ((zzgr)zza2).zzq().zza(new zze(zza2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        if (!((zzgr)this).zzt().zzj().booleanValue()) {
            return;
        }
        zzih zzih2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        long l = ((zzgr)this).zzm().elapsedRealtime();
        ((zzgr)this).zzq().zza(new zzii(this, zzih2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzgr)this).zzt().zzj().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzih zzih2 = this.zzd.get(activity);
        if (zzih2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzih2.zzc);
        bundle2.putString("name", zzih2.zza);
        bundle2.putString("referrer_name", zzih2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        if (!((zzgr)this).zzt().zzj().booleanValue()) {
            return;
        }
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzig zzig2, zzih zzih2, boolean bl, long l) {
        zzig2.zza(zzih2, bl, l);
    }
}

