/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzv;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfx
implements zzgu {
    private static volatile zzfx zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzv zzh;
    private final zzaa zzi;
    private final zzff zzj;
    private final zzet zzk;
    private final zzfu zzl;
    private final zzjs zzm;
    private final zzko zzn;
    private final zzer zzo;
    private final Clock zzp;
    private final zzih zzq;
    private final zzhc zzr;
    private final zzb zzs;
    private final zzic zzt;
    private zzep zzu;
    private zzin zzv;
    private zzak zzw;
    private zzeq zzx;
    private zzfo zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private int zzaf;
    private AtomicInteger zzag = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzfx(zzgz zzgz2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgz2);
        Object object2 = zzgz2.zza;
        zzej.zza = this.zzh = new zzv((Context)object2);
        this.zzc = zzgz2.zza;
        this.zzd = zzgz2.zzb;
        this.zze = zzgz2.zzc;
        this.zzf = zzgz2.zzd;
        this.zzg = zzgz2.zzh;
        this.zzac = zzgz2.zze;
        com.google.android.gms.internal.measurement.zzaa zzaa2 = zzgz2.zzg;
        if (zzaa2 != null && zzaa2.zzg != null) {
            object = zzaa2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzaa2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzcq.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzgz2.zzi != null ? zzgz2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzaa((zzfx)object2);
        object2 = this;
        object = new zzff((zzfx)object2);
        ((zzgr)object).zzab();
        this.zzj = object;
        object2 = this;
        zzet zzet2 = new zzet((zzfx)object2);
        zzet2.zzab();
        this.zzk = zzet2;
        object2 = this;
        zzko zzko2 = new zzko((zzfx)object2);
        zzko2.zzab();
        this.zzn = zzko2;
        object2 = this;
        zzer zzer2 = new zzer((zzfx)object2);
        zzer2.zzab();
        this.zzo = zzer2;
        object2 = this;
        this.zzs = new zzb((zzfx)object2);
        object2 = this;
        zzih zzih2 = new zzih((zzfx)object2);
        zzih2.zzx();
        this.zzq = zzih2;
        object2 = this;
        zzhc zzhc2 = new zzhc((zzfx)object2);
        zzhc2.zzx();
        this.zzr = zzhc2;
        object2 = this;
        zzjs zzjs2 = new zzjs((zzfx)object2);
        zzjs2.zzx();
        this.zzm = zzjs2;
        object2 = this;
        zzic zzic2 = new zzic((zzfx)object2);
        zzic2.zzab();
        this.zzt = zzic2;
        object2 = this;
        zzfu zzfu2 = new zzfu((zzfx)object2);
        zzfu2.zzab();
        this.zzl = zzfu2;
        boolean bl = zzgz2.zzg != null && zzgz2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzv zzv2 = ((zzfx)object2).zzh;
        if (((zzfx)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhc zzhc3 = ((zzfx)object2).zzh();
            if (((zzgs)zzhc3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgs)zzhc3).zzn().getApplicationContext();
                if (zzhc3.zza == null) {
                    zzhc3.zza = new zzhx(zzhc3, null);
                }
                if (bl3) {
                    zzhx zzhx2 = zzhc3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhx2);
                    zzhx2 = zzhc3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhx2);
                    ((zzgs)zzhc3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfx)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzfz(this, zzgz2));
    }

    @WorkerThread
    private final void zza(zzgz zzgz2) {
        ((zzgs)this.zzq()).zzd();
        Object object = this;
        zzak zzak2 = new zzak((zzfx)object);
        zzak2.zzab();
        this.zzw = zzak2;
        zzfx zzfx2 = this;
        object = zzgz2;
        zzeq zzeq2 = new zzeq(zzfx2, ((zzgz)object).zzf);
        zzeq2.zzx();
        this.zzx = zzeq2;
        object = this;
        zzep zzep2 = new zzep((zzfx)object);
        zzep2.zzx();
        this.zzu = zzep2;
        object = this;
        zzin zzin2 = new zzin((zzfx)object);
        zzin2.zzx();
        this.zzv = zzin2;
        this.zzn.zzac();
        this.zzj.zzac();
        object = this;
        this.zzy = new zzfo((zzfx)object);
        this.zzx.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzi.zzf());
        zzv zzv2 = this.zzh;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzv2 = this.zzh;
        String string = zzeq2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzev zzev2;
            if (this.zzi().zzf(string)) {
                zzev2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzev2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzev2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzaf != this.zzag.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzaf, this.zzag.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza() {
        zzv zzv2;
        ((zzgs)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zza);
            this.zzc().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzas.zzcp)) {
            zzv2 = this.zzh;
            this.zzh().zzb.zzb();
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzv2 = this.zzh;
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzy()) {
                    if (!zzfp.zza(this.zzc)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzko.zza(this.zzc, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzv2 = this.zzh;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzko.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzv.zzah();
                    this.zzv.zzaf();
                    this.zzc().zzh.zza(this.zza);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzv2 = this.zzh;
            if (zzka.zzb() && this.zzi.zza(zzas.zzbv) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzv.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzv.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzi.zzh()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzi.zza(zzas.zzaz));
        this.zzc().zzp.zza(this.zzi.zza(zzas.zzba));
    }

    @Override
    public final zzv zzu() {
        return this.zzh;
    }

    public final zzaa zzb() {
        return this.zzi;
    }

    public final zzff zzc() {
        zzfx.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzet zzr() {
        zzfx.zzb(this.zzk);
        return this.zzk;
    }

    public final zzet zzd() {
        if (this.zzk != null && this.zzk.zzz()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzfu zzq() {
        zzfx.zzb(this.zzl);
        return this.zzl;
    }

    public final zzjs zze() {
        zzfx.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfo zzf() {
        return this.zzy;
    }

    final zzfu zzg() {
        return this.zzl;
    }

    public final zzhc zzh() {
        zzfx.zzb(this.zzr);
        return this.zzr;
    }

    public final zzko zzi() {
        zzfx.zza(this.zzn);
        return this.zzn;
    }

    public final zzer zzj() {
        zzfx.zza(this.zzo);
        return this.zzo;
    }

    public final zzep zzk() {
        zzfx.zzb(this.zzu);
        return this.zzu;
    }

    private final zzic zzai() {
        zzfx.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzn() {
        return this.zzc;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzo() {
        return this.zzd;
    }

    public final String zzp() {
        return this.zze;
    }

    public final String zzs() {
        return this.zzf;
    }

    public final boolean zzt() {
        return this.zzg;
    }

    @Override
    public final Clock zzm() {
        return this.zzp;
    }

    public final zzih zzv() {
        zzfx.zzb(this.zzq);
        return this.zzq;
    }

    public final zzin zzw() {
        zzfx.zzb(this.zzv);
        return this.zzv;
    }

    public final zzak zzx() {
        zzfx.zzb(this.zzw);
        return this.zzw;
    }

    public final zzeq zzy() {
        zzfx.zzb(this.zzx);
        return this.zzx;
    }

    public final zzb zzz() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @VisibleForTesting
    public static zzfx zza(Context context, String string, String string2, Bundle bundle) {
        return zzfx.zza(context, new com.google.android.gms.internal.measurement.zzaa(0L, 0L, true, null, null, null, bundle), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfx zza(Context context, com.google.android.gms.internal.measurement.zzaa zzaa2, Long l) {
        if (zzaa2 != null && (zzaa2.zze == null || zzaa2.zzf == null)) {
            zzaa2 = new com.google.android.gms.internal.measurement.zzaa(zzaa2.zza, zzaa2.zzb, zzaa2.zzc, zzaa2.zzd, null, null, zzaa2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzfx> clazz = zzfx.class;
            synchronized (zzfx.class) {
                if (zzb == null) {
                    zzgz zzgz2 = new zzgz(context, zzaa2, l);
                    zzb = new zzfx(zzgz2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzaa2 != null && zzaa2.zzg != null && zzaa2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzaa2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgr zzgr2) {
        if (zzgr2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgr2.zzz()) {
            String string = String.valueOf(zzgr2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgs zzgs2) {
        if (zzgs2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac() == 0;
    }

    @WorkerThread
    public final int zzac() {
        ((zzgs)this.zzq()).zzd();
        if (this.zzi.zzh()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzaa zzaa2 = this.zzi;
        zzv zzv2 = ((zzgs)zzaa2).zzu();
        Boolean bl2 = zzaa2.zzd("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzas.zzas) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final void zzad() {
        zzv zzv2 = this.zzh;
    }

    final void zzae() {
        zzv zzv2 = this.zzh;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgr zzgr2) {
        ++this.zzaf;
    }

    final void zza(zze zze2) {
        ++this.zzaf;
    }

    final void zzaf() {
        this.zzag.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgs)this.zzq()).zzd();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            zzv zzv2 = this.zzh;
            this.zzaa = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzy() || zzfp.zza(this.zzc) && zzko.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgs)this.zzq()).zzd();
        zzfx.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzi.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgs)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzu.zza() - 1L);
        zzga zzga2 = new zzga(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzic zzic2 = this.zzai();
        ((zzgs)zzic2).zzd();
        zzic2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzga2);
        ((zzgs)zzic2).zzq().zzb(new zzie(zzic2, string2, uRL2, null, null, zzga2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfx zzfx2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfx2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfx2.zzc().zzt.zza(true);
        if (byArray2.length == 0) {
            zzfx2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzfx2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzko zzko2 = zzfx2.zzi();
            ((zzgs)zzko2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgs)zzko2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfx2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfx2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzko2 = zzfx2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzko2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgs)zzko2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfx2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfx zzfx2, zzgz zzgz2) {
        zzfx2.zza(zzgz2);
    }
}

