/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzkr;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfg
extends zzgv {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzz;
    public zzfn zzb;
    public final zzfk zzc = new zzfk(this, "last_upload", 0L);
    public final zzfk zzd = new zzfk(this, "last_upload_attempt", 0L);
    public final zzfk zze = new zzfk(this, "backoff", 0L);
    public final zzfk zzf = new zzfk(this, "last_delete_stale", 0L);
    public final zzfk zzg;
    public final zzfk zzh;
    public final zzfk zzi;
    public final zzfm zzj;
    private String zzaa;
    private boolean zzab;
    private long zzac;
    public final zzfk zzk = new zzfk(this, "time_before_start", 10000L);
    public final zzfk zzl = new zzfk(this, "session_timeout", 1800000L);
    public final zzfi zzm = new zzfi(this, "start_new_session", true);
    public final zzfm zzn;
    public final zzfi zzo;
    public final zzfk zzp = new zzfk(this, "last_pause_time", 0L);
    public boolean zzq;
    public zzfi zzr;
    public zzfi zzs;
    public zzfk zzt;
    public final zzfm zzu;
    public final zzfm zzv;
    public final zzfk zzw;
    public final zzfl zzx;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzaa != null && l < this.zzac) {
            return new Pair((Object)this.zzaa, (Object)this.zzab);
        }
        String string2 = string;
        this.zzac = l + this.zzt().zza(string2, zzaq.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzaa = info.getId();
                this.zzab = info.isLimitAdTrackingEnabled();
            }
            if (this.zzaa == null) {
                this.zzaa = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzaa = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzaa, (Object)this.zzab);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzkr.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfg(zzfy zzfy2) {
        super(zzfy2);
        this.zzn = new zzfm(this, "non_personalized_ads", null);
        this.zzo = new zzfi(this, "allow_remote_dynamite", false);
        this.zzg = new zzfk(this, "midnight_offset", 0L);
        this.zzh = new zzfk(this, "first_open_time", 0L);
        this.zzi = new zzfk(this, "app_install_time", 0L);
        this.zzj = new zzfm(this, "app_instance_id", null);
        this.zzr = new zzfi(this, "app_backgrounded", false);
        this.zzs = new zzfi(this, "deep_link_retrieval_complete", false);
        this.zzt = new zzfk(this, "deep_link_retrieval_attempts", 0L);
        this.zzu = new zzfm(this, "firebase_feature_rollouts", null);
        this.zzv = new zzfm(this, "deferred_attribution_cache", null);
        this.zzw = new zzfk(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzx = new zzfl(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzz = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzq = this.zzz.getBoolean("has_been_opened", false);
        if (!this.zzq) {
            SharedPreferences.Editor editor = this.zzz.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfn(this, "health_monitor", Math.max(0L, (Long)zzaq.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzg() {
        this.zzd();
        this.zzaa();
        return this.zzz;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzg().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzi() {
        this.zzd();
        return this.zzg().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzj() {
        this.zzd();
        if (!this.zzg().contains("use_service")) {
            return null;
        }
        return this.zzg().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzk() {
        this.zzd();
        Boolean bl = this.zzv();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zzb(bl);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final Boolean zzv() {
        this.zzd();
        if (this.zzg().contains("measurement_enabled")) {
            return this.zzg().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzw() {
        this.zzd();
        String string = this.zzg().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzg().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzc(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzz.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzp.zza();
    }
}

