/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgv;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfv
extends zzgv {
    private zzfz zza;
    private zzfz zzb;
    private final PriorityBlockingQueue<zzfw<?>> zzc;
    private final BlockingQueue<zzfw<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfv(zzfy zzfy2) {
        super(zzfy2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfx(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfx(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfw zzfw2 = new zzfw(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgs)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzfw2.run();
        } else {
            this.zza(zzfw2);
        }
        return zzfw2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfw zzfw2 = new zzfw(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfw2.run();
        } else {
            this.zza(zzfw2);
        }
        return zzfw2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfw(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgs)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgs)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgs)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfw<?> zzfw2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfw2);
            if (this.zza == null) {
                this.zza = new zzfz(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzfw zzfw2 = new zzfw(this, runnable, false, "Task exception on network thread");
        zzfv zzfv2 = this;
        Object object = zzfv2.zzg;
        synchronized (object) {
            zzfv2.zzd.add(zzfw2);
            if (zzfv2.zzb == null) {
                zzfv2.zzb = new zzfz(zzfv2, "Measurement Network", zzfv2.zzd);
                zzfv2.zzb.setUncaughtExceptionHandler(zzfv2.zzf);
                zzfv2.zzb.start();
            } else {
                zzfv2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfv zzfv2) {
        return zzfv2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfv zzfv2) {
        return zzfv2.zzi;
    }

    static /* synthetic */ Object zzc(zzfv zzfv2) {
        return zzfv2.zzg;
    }

    static /* synthetic */ zzfz zzd(zzfv zzfv2) {
        return zzfv2.zza;
    }

    static /* synthetic */ zzfz zza(zzfv zzfv2, zzfz zzfz2) {
        zzfv2.zza = null;
        return null;
    }

    static /* synthetic */ zzfz zze(zzfv zzfv2) {
        return zzfv2.zzb;
    }

    static /* synthetic */ zzfz zzb(zzfv zzfv2, zzfz zzfz2) {
        zzfv2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

