/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzlr;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfy
implements zzgu {
    private static volatile zzfy zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzx zzh;
    private final zzy zzi;
    private final zzfg zzj;
    private final zzeu zzk;
    private final zzfv zzl;
    private final zzjv zzm;
    private final zzkr zzn;
    private final zzes zzo;
    private final Clock zzp;
    private final zzii zzq;
    private final zzhc zzr;
    private final zza zzs;
    private final zzid zzt;
    private zzeq zzu;
    private zzir zzv;
    private zzai zzw;
    private zzer zzx;
    private zzfp zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private int zzaf;
    private AtomicInteger zzag = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzfy(zzhd zzhd2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhd2);
        Object object2 = zzhd2.zza;
        zzek.zza = this.zzh = new zzx((Context)object2);
        this.zzc = zzhd2.zza;
        this.zzd = zzhd2.zzb;
        this.zze = zzhd2.zzc;
        this.zzf = zzhd2.zzd;
        this.zzg = zzhd2.zzh;
        this.zzac = zzhd2.zze;
        zzae zzae2 = zzhd2.zzg;
        if (zzae2 != null && zzae2.zzg != null) {
            object = zzae2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzae2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzcv.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzhd2.zzi != null ? zzhd2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzy((zzfy)object2);
        object2 = this;
        object = new zzfg((zzfy)object2);
        ((zzgv)object).zzab();
        this.zzj = object;
        object2 = this;
        zzeu zzeu2 = new zzeu((zzfy)object2);
        zzeu2.zzab();
        this.zzk = zzeu2;
        object2 = this;
        zzkr zzkr2 = new zzkr((zzfy)object2);
        zzkr2.zzab();
        this.zzn = zzkr2;
        object2 = this;
        zzes zzes2 = new zzes((zzfy)object2);
        zzes2.zzab();
        this.zzo = zzes2;
        object2 = this;
        this.zzs = new zza((zzfy)object2);
        object2 = this;
        zzii zzii2 = new zzii((zzfy)object2);
        zzii2.zzx();
        this.zzq = zzii2;
        object2 = this;
        zzhc zzhc2 = new zzhc((zzfy)object2);
        zzhc2.zzx();
        this.zzr = zzhc2;
        object2 = this;
        zzjv zzjv2 = new zzjv((zzfy)object2);
        zzjv2.zzx();
        this.zzm = zzjv2;
        object2 = this;
        zzid zzid2 = new zzid((zzfy)object2);
        zzid2.zzab();
        this.zzt = zzid2;
        object2 = this;
        zzfv zzfv2 = new zzfv((zzfy)object2);
        zzfv2.zzab();
        this.zzl = zzfv2;
        boolean bl = zzhd2.zzg != null && zzhd2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzx zzx2 = ((zzfy)object2).zzh;
        if (((zzfy)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhc zzhc3 = ((zzfy)object2).zzh();
            if (((zzgs)zzhc3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgs)zzhc3).zzn().getApplicationContext();
                if (zzhc3.zza == null) {
                    zzhc3.zza = new zzhy(zzhc3, null);
                }
                if (bl3) {
                    zzhy zzhy2 = zzhc3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhy2);
                    zzhy2 = zzhc3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhy2);
                    ((zzgs)zzhc3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfy)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzga(this, zzhd2));
    }

    @WorkerThread
    private final void zza(zzhd zzhd2) {
        ((zzgs)this.zzq()).zzd();
        Object object = this;
        zzai zzai2 = new zzai((zzfy)object);
        zzai2.zzab();
        this.zzw = zzai2;
        zzfy zzfy2 = this;
        object = zzhd2;
        zzer zzer2 = new zzer(zzfy2, ((zzhd)object).zzf);
        zzer2.zzx();
        this.zzx = zzer2;
        object = this;
        zzeq zzeq2 = new zzeq((zzfy)object);
        zzeq2.zzx();
        this.zzu = zzeq2;
        object = this;
        zzir zzir2 = new zzir((zzfy)object);
        zzir2.zzx();
        this.zzv = zzir2;
        this.zzn.zzac();
        this.zzj.zzac();
        object = this;
        this.zzy = new zzfp((zzfy)object);
        this.zzx.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzi.zzf());
        zzx zzx2 = this.zzh;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzx2 = this.zzh;
        String string = zzer2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzew zzew2;
            if (this.zzi().zzf(string)) {
                zzew2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzew2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzew2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzaf != this.zzag.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzaf, this.zzag.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza() {
        zzx zzx2;
        ((zzgs)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zza);
            this.zzc().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzaq.zzcq)) {
            zzx2 = this.zzh;
            this.zzh().zzb.zzb();
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzx2 = this.zzh;
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzy()) {
                    if (!zzfq.zza(this.zzc)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkr.zza(this.zzc, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzx2 = this.zzh;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzkr.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzv.zzah();
                    this.zzv.zzaf();
                    this.zzc().zzh.zza(this.zza);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzx2 = this.zzh;
            if (zzkh.zzb() && this.zzi.zza(zzaq.zzbu) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzu.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzu.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzi.zzh()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
                if (zzlr.zzb() && this.zzi.zza(zzaq.zzcm)) {
                    this.zzw().zza(this.zzc().zzx.zza());
                }
            }
        }
        this.zzc().zzo.zza(this.zzi.zza(zzaq.zzaz));
    }

    @Override
    public final zzx zzu() {
        return this.zzh;
    }

    public final zzy zzb() {
        return this.zzi;
    }

    public final zzfg zzc() {
        zzfy.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzeu zzr() {
        zzfy.zzb(this.zzk);
        return this.zzk;
    }

    public final zzeu zzd() {
        if (this.zzk != null && this.zzk.zzz()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzfv zzq() {
        zzfy.zzb(this.zzl);
        return this.zzl;
    }

    public final zzjv zze() {
        zzfy.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfp zzf() {
        return this.zzy;
    }

    final zzfv zzg() {
        return this.zzl;
    }

    public final zzhc zzh() {
        zzfy.zzb(this.zzr);
        return this.zzr;
    }

    public final zzkr zzi() {
        zzfy.zza(this.zzn);
        return this.zzn;
    }

    public final zzes zzj() {
        zzfy.zza(this.zzo);
        return this.zzo;
    }

    public final zzeq zzk() {
        zzfy.zzb(this.zzu);
        return this.zzu;
    }

    private final zzid zzai() {
        zzfy.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzn() {
        return this.zzc;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzo() {
        return this.zzd;
    }

    public final String zzp() {
        return this.zze;
    }

    public final String zzs() {
        return this.zzf;
    }

    public final boolean zzt() {
        return this.zzg;
    }

    @Override
    public final Clock zzm() {
        return this.zzp;
    }

    public final zzii zzv() {
        zzfy.zzb(this.zzq);
        return this.zzq;
    }

    public final zzir zzw() {
        zzfy.zzb(this.zzv);
        return this.zzv;
    }

    public final zzai zzx() {
        zzfy.zzb(this.zzw);
        return this.zzw;
    }

    public final zzer zzy() {
        zzfy.zzb(this.zzx);
        return this.zzx;
    }

    public final zza zzz() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfy zza(Context context, zzae zzae2, Long l) {
        if (zzae2 != null && (zzae2.zze == null || zzae2.zzf == null)) {
            zzae2 = new zzae(zzae2.zza, zzae2.zzb, zzae2.zzc, zzae2.zzd, null, null, zzae2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzfy> clazz = zzfy.class;
            synchronized (zzfy.class) {
                if (zzb == null) {
                    zzhd zzhd2 = new zzhd(context, zzae2, l);
                    zzb = new zzfy(zzhd2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzae2 != null && zzae2.zzg != null && zzae2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzae2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgv zzgv2) {
        if (zzgv2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgv2.zzz()) {
            String string = String.valueOf(zzgv2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzv()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgs zzgs2) {
        if (zzgs2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac() == 0;
    }

    @WorkerThread
    public final int zzac() {
        ((zzgs)this.zzq()).zzd();
        if (this.zzi.zzh()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzy zzy2 = this.zzi;
        zzx zzx2 = ((zzgs)zzy2).zzu();
        Boolean bl2 = zzy2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzaq.zzas) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final void zzad() {
        zzx zzx2 = this.zzh;
    }

    final void zzae() {
        zzx zzx2 = this.zzh;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgv zzgv2) {
        ++this.zzaf;
    }

    final void zza(zzg zzg2) {
        ++this.zzaf;
    }

    final void zzaf() {
        this.zzag.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgs)this.zzq()).zzd();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            zzx zzx2 = this.zzh;
            this.zzaa = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzy() || zzfq.zza(this.zzc) && zzkr.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgs)this.zzq()).zzd();
        zzfy.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzi.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgs)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzt.zza() - 1L);
        zzgb zzgb2 = new zzgb(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzid zzid2 = this.zzai();
        ((zzgs)zzid2).zzd();
        zzid2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzgb2);
        ((zzgs)zzid2).zzq().zzb(new zzif(zzid2, string2, uRL2, null, null, zzgb2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfy zzfy2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfy2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfy2.zzc().zzs.zza(true);
        if (byArray2.length == 0) {
            zzfy2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzfy2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkr zzkr2 = zzfy2.zzi();
            ((zzgs)zzkr2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgs)zzkr2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfy2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfy2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkr2 = zzfy2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkr2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgs)zzkr2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfy2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfy zzfy2, zzhd zzhd2) {
        zzfy2.zza(zzhd2);
    }
}

