/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzjw;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzko;
import com.google.android.gms.internal.measurement.zzla;
import com.google.android.gms.internal.measurement.zzlr;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhc
extends zzg {
    @VisibleForTesting
    protected zzhy zza;
    private zzhb zzd;
    private final Set<zzha> zze = new CopyOnWriteArraySet<zzha>();
    private boolean zzf;
    private final AtomicReference<String> zzg = new AtomicReference();
    final zzp zzb;
    @VisibleForTesting
    protected boolean zzc = true;

    protected zzhc(zzfy zzfy2) {
        super(zzfy2);
        this.zzb = new zzp(zzfy2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    public final void zzab() {
        if (((zzgs)this).zzn().getApplicationContext() instanceof Application) {
            zzhy zzhy2 = this.zza;
            ((Application)((zzgs)this).zzn().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhy2);
        }
    }

    public final Boolean zzac() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzgs)this).zzq().zza(atomicReference, 15000L, "boolean test flag value", new zzhh(this, atomicReference));
    }

    public final String zzad() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzgs)this).zzq().zza(atomicReference, 15000L, "String test flag value", new zzho(this, atomicReference));
    }

    public final Long zzae() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzgs)this).zzq().zza(atomicReference, 15000L, "long test flag value", new zzht(this, atomicReference));
    }

    public final Integer zzaf() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzgs)this).zzq().zza(atomicReference, 15000L, "int test flag value", new zzhs(this, atomicReference));
    }

    public final Double zzag() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzgs)this).zzq().zza(atomicReference, 15000L, "double test flag value", new zzhv(this, atomicReference));
    }

    public final void zza(boolean bl) {
        this.zzw();
        ((zzgs)this).zzb();
        ((zzgs)this).zzq().zza(new zzhu(this, bl));
    }

    @WorkerThread
    private final void zzc(boolean bl) {
        ((zzgs)this).zzd();
        ((zzgs)this).zzb();
        this.zzw();
        ((zzgs)this).zzr().zzw().zza("Setting app measurement enabled (FE)", bl);
        ((zzgs)this).zzs().zzb(bl);
        this.zzam();
    }

    @WorkerThread
    private final void zzam() {
        Object object = this;
        ((zzgs)object).zzd();
        String string = ((zzgs)object).zzs().zzn.zza();
        if (string != null) {
            if ("unset".equals(string)) {
                ((zzhc)object).zza("app", "_npa", null, ((zzgs)object).zzm().currentTimeMillis());
            } else {
                ((zzhc)object).zza("app", "_npa", (Object)("true".equals(string) ? 1L : 0L), ((zzgs)object).zzm().currentTimeMillis());
            }
        }
        if (this.zzy.zzab() && this.zzc) {
            ((zzgs)this).zzr().zzw().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzai();
            if (zzla.zzb() && ((zzgs)this).zzt().zza(zzaq.zzbv)) {
                ((zzd)this).zzk().zza.zza();
            }
            if (zzko.zzb() && ((zzgs)this).zzt().zza(zzaq.zzca) && !(this.zzy.zzf().zza.zzc().zzi.zza() > 0L)) {
                object = this.zzy.zzf();
                ((zzfp)object).zza.zzad();
                ((zzfp)object).zza(((zzfp)object).zza.zzn().getPackageName());
            }
            if (((zzgs)this).zzt().zza(zzaq.zzcq)) {
                ((zzgs)this).zzq().zza(new zzhw(this));
            }
            return;
        }
        ((zzgs)this).zzr().zzw().zza("Updating Scion state (FE)");
        ((zzd)this).zzh().zzac();
    }

    public final void zza(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, ((zzgs)this).zzm().currentTimeMillis());
    }

    @WorkerThread
    final void zzb(String string, String string2, Bundle bundle) {
        ((zzgs)this).zzb();
        ((zzgs)this).zzd();
        this.zza(string, string2, ((zzgs)this).zzm().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzgs)this).zzb();
        ((zzgs)this).zzd();
        boolean bl = this.zzd == null || zzkr.zze(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    @WorkerThread
    protected final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Bundle bundle3;
        int n;
        Object object2;
        String string4;
        Object object3;
        Object object4;
        Class<?> clazz;
        zzgs zzgs2;
        Object object5;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)bundle);
        ((zzgs)this).zzd();
        this.zzw();
        if (!this.zzy.zzab()) {
            ((zzgs)this).zzr().zzw().zza("Event not sent since app measurement is disabled");
            return;
        }
        if (((zzgs)this).zzt().zza(zzaq.zzbb) && (object5 = ((zzd)this).zzg().zzah()) != null && !object5.contains(string2)) {
            ((zzgs)this).zzr().zzw().zza("Dropping non-safelisted event. event name, origin", string2, string);
            return;
        }
        if (!this.zzf) {
            this.zzf = true;
            zzgs2 = this;
            try {
                clazz = !((zzhc)zzgs2).zzy.zzt() ? Class.forName("com.google.android.gms.tagmanager.TagManagerService", true, zzgs2.zzn().getClassLoader()) : Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz2 = clazz;
                object4 = zzgs2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzgs)object4).zzn());
                }
                catch (Exception exception) {
                    ((zzgs)object4).zzr().zzi().zza("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzgs2.zzr().zzv().zza("Tag Manager is not found and thus will not be used");
            }
        }
        if (((zzgs)this).zzt().zza(zzaq.zzbh) && "_cmp".equals(string2) && bundle.containsKey("gclid")) {
            this.zza("auto", "_lgclid", (Object)bundle.getString("gclid"), ((zzgs)this).zzm().currentTimeMillis());
        }
        if (zzlr.zzb() && ((zzgs)this).zzt().zza(zzaq.zzcm)) {
            object4 = ((zzgs)this).zzu();
            if (bl && zzkr.zzg(string2)) {
                ((zzgs)this).zzp().zza(bundle, ((zzgs)this).zzs().zzx.zza());
            }
        }
        if (bl3) {
            object4 = ((zzgs)this).zzu();
            if (!"_iap".equals(string2)) {
                int n2;
                clazz = string2;
                zzgs2 = this.zzy.zzi();
                if ((!((zzkr)zzgs2).zza("event", (String)((Object)clazz)) ? 2 : (!((zzkr)zzgs2).zza("event", zzgw.zza, (String)((Object)clazz)) ? 13 : (n2 = !((zzkr)zzgs2).zza("event", 40, (String)((Object)clazz)) ? 2 : 0))) != 0) {
                    ((zzgs)this).zzr().zzh().zza("Invalid public event name. Event will not be logged (FE)", ((zzgs)this).zzo().zza(string2));
                    this.zzy.zzi();
                    String string5 = zzkr.zza(string2, 40, true);
                    int n3 = string2 != null ? string2.length() : 0;
                    this.zzy.zzi().zza(n2, "_ev", string5, n3);
                    return;
                }
            }
        }
        object4 = ((zzgs)this).zzu();
        zzij zzij2 = ((zzd)this).zzi().zza(false);
        if (zzij2 != null && !bundle.containsKey("_sc")) {
            zzij2.zzd = true;
        }
        object5 = zzij2;
        zzii.zza((zzij)object5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzkr.zze(string2);
        if (bl && this.zzd != null && !bl5 && !bl4) {
            ((zzgs)this).zzr().zzw().zza("Passing event to registered event handler (FE)", ((zzgs)this).zzo().zza(string2), ((zzgs)this).zzo().zza(bundle));
            this.zzd.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzy.zzag()) {
            return;
        }
        int n4 = ((zzgs)this).zzp().zzb(string2);
        if (n4 != 0) {
            ((zzgs)this).zzr().zzh().zza("Invalid event name. Event will not be logged (FE)", ((zzgs)this).zzo().zza(string2));
            ((zzgs)this).zzp();
            String string6 = zzkr.zza(string2, 40, true);
            int n5 = string2 != null ? string2.length() : 0;
            this.zzy.zzi().zza(string3, n4, "_ev", string6, n5);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle4 = ((zzgs)this).zzp().zza(string3, string2, bundle, list, bl3, true);
        zzgs2 = bundle4;
        if (bundle4 == null || !zzgs2.containsKey("_sc") || !zzgs2.containsKey("_si")) {
            object3 = null;
        } else {
            clazz = zzgs2.getString("_sn");
            string4 = zzgs2.getString("_sc");
            Long l2 = zzgs2.getLong("_si");
            object3 = object2 = new zzij((String)((Object)clazz), string4, l2);
        }
        if (object3 == null) {
            object2 = object5;
        }
        if (((zzgs)this).zzt().zza(zzaq.zzat)) {
            long l3;
            object4 = ((zzgs)this).zzu();
            if (((zzd)this).zzi().zza(false) != null && "_ae".equals(string2) && (l3 = ((zzd)this).zzk().zzb.zzb()) > 0L) {
                ((zzgs)this).zzp().zza(bundle4, l3);
            }
        }
        if (zzkh.zzb() && ((zzgs)this).zzt().zza(zzaq.zzbu)) {
            if (!"auto".equals(string) && "_ssr".equals(string2)) {
                boolean bl6;
                clazz = bundle4;
                zzgs2 = ((zzgs)this).zzp();
                string4 = clazz.getString("_ffr");
                string4 = Strings.isEmptyOrWhitespace((String)string4) ? null : string4.trim();
                if (zzkr.zzc(string4, zzgs2.zzs().zzu.zza())) {
                    zzgs2.zzr().zzw().zza("Not logging duplicate session_start_with_rollout event");
                    bl6 = false;
                } else {
                    zzgs2.zzs().zzu.zza(string4);
                    bl6 = true;
                }
                if (!bl6) {
                    return;
                }
            } else if ("_ae".equals(string2)) {
                clazz = bundle4;
                string4 = ((zzgs)((zzgs)this).zzp()).zzs().zzu.zza();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    clazz.putString("_ffr", string4);
                }
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle4);
        long l4 = ((zzgs)this).zzp().zzh().nextLong();
        if (((zzgs)this).zzs().zzp.zza() > 0L && ((zzgs)this).zzs().zza(l) && ((zzgs)this).zzs().zzr.zza()) {
            ((zzgs)this).zzr().zzx().zza("Current session is expired, remove the session number, ID, and engagement time");
            this.zza("auto", "_sid", null, ((zzgs)this).zzm().currentTimeMillis());
            this.zza("auto", "_sno", null, ((zzgs)this).zzm().currentTimeMillis());
            this.zza("auto", "_se", null, ((zzgs)this).zzm().currentTimeMillis());
        }
        if (bundle4.getLong("extend_session", 0L) == 1L) {
            ((zzgs)this).zzr().zzx().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            long l5 = l;
            this.zzy.zze().zza.zza(l5, true);
        }
        Object[] objectArray = bundle4.keySet().toArray(new String[bundle4.size()]);
        Arrays.sort(objectArray);
        if (zzjw.zzb() && ((zzgs)this).zzt().zza(zzaq.zzcg) && ((zzgs)this).zzt().zza(zzaq.zzcf)) {
            Object[] objectArray2 = objectArray;
            int n6 = objectArray.length;
            for (n = 0; n < n6; ++n) {
                Object object6 = objectArray2[n];
                ((zzgs)this).zzp();
                bundle3 = zzkr.zzb(bundle4.get((String)object6));
                if (bundle3 == null) continue;
                bundle4.putParcelableArray((String)object6, (Parcelable[])bundle3);
            }
        } else {
            int n7 = 0;
            Object[] objectArray3 = objectArray;
            n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                bundle3 = objectArray3[i];
                object = bundle4.get((String)bundle3);
                ((zzgs)this).zzp();
                Bundle[] bundleArray = zzkr.zzb(object);
                if (bundleArray == null) continue;
                bundle4.putInt((String)bundle3, bundleArray.length);
                for (int j = 0; j < bundleArray.length; ++j) {
                    bundle2 = bundleArray[j];
                    zzii.zza((zzij)object2, bundle2, true);
                    Bundle bundle5 = ((zzgs)this).zzp().zza(string3, "_ep", bundle2, list, bl3, false);
                    bundle5.putString("_en", string2);
                    bundle5.putLong("_eid", l4);
                    bundle5.putString("_gn", (String)bundle3);
                    bundle5.putInt("_ll", bundleArray.length);
                    bundle5.putInt("_i", j);
                    arrayList.add(bundle5);
                }
                n7 += bundleArray.length;
            }
            if (n7 != 0) {
                bundle4.putLong("_eid", l4);
                bundle4.putInt("_epc", n7);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle6 = (Bundle)arrayList.get(i);
            String string7 = i != 0 ? "_ep" : string2;
            bundle6.putString("_o", string);
            bundle3 = bl2 ? ((zzgs)this).zzp().zza(bundle6) : bundle6;
            object = new zzao(string7, new zzan(bundle3), string, l);
            ((zzd)this).zzh().zza((zzao)((Object)object), string3);
            if (bl4) continue;
            for (zzha zzha2 : this.zze) {
                bundle2 = new Bundle(bundle3);
                zzha2.onEvent(string, string2, bundle2, l);
            }
        }
        object4 = ((zzgs)this).zzu();
        if (((zzd)this).zzi().zza(false) != null && "_ae".equals(string2)) {
            ((zzd)this).zzk().zza(true, true, ((zzgs)this).zzm().elapsedRealtime());
        }
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        ((zzgs)this).zzb();
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (((zzgs)this).zzt().zza(zzaq.zzcc) && zzkr.zzc(string2, "screen_view")) {
            ((zzd)this).zzi().zza(bundle);
            return;
        }
        boolean bl3 = !bl2 || this.zzd == null || zzkr.zze(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzkr.zzb(bundle);
        ((zzgs)this).zzq().zza(new zzhj(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, true, ((zzgs)this).zzm().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzgs)this).zzp().zzc(string2);
        } else {
            String string3 = string2;
            zzkr zzkr2 = ((zzgs)this).zzp();
            n2 = !zzkr2.zza("user property", string3) ? 6 : (!zzkr2.zza("user property", zzgy.zza, string3) ? 15 : (n = !zzkr2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzgs)this).zzp();
            String string4 = zzkr.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzy.zzi().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzgs)this).zzp().zzb(string2, object);
            if (n != 0) {
                ((zzgs)this).zzp();
                String string5 = zzkr.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzy.zzi().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzgs)this).zzp().zzc(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzgs)this).zzq().zza(new zzhi(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzgs)this).zzd();
        ((zzgs)this).zzb();
        this.zzw();
        if ("allow_personalized_ads".equals(string2)) {
            if (object instanceof String && !TextUtils.isEmpty((CharSequence)((String)object))) {
                object = "false".equals(((String)object).toLowerCase(Locale.ENGLISH)) ? 1L : 0L;
                string2 = "_npa";
                ((zzgs)this).zzs().zzn.zza((Long)object == 1L ? "true" : "false");
            } else if (object == null) {
                string2 = "_npa";
                ((zzgs)this).zzs().zzn.zza("unset");
            }
        }
        if (!this.zzy.zzab()) {
            ((zzgs)this).zzr().zzx().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzy.zzag()) {
            return;
        }
        zzkq zzkq2 = new zzkq(string2, l, object, string);
        ((zzd)this).zzh().zza(zzkq2);
    }

    public final List<zzkq> zzb(boolean bl) {
        ((zzgs)this).zzb();
        this.zzw();
        ((zzgs)this).zzr().zzx().zza("Getting user properties (FE)");
        if (((zzgs)this).zzq().zzg()) {
            ((zzgs)this).zzr().zzf().zza("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzx.zza()) {
            ((zzgs)this).zzr().zzf().zza("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzq().zza(atomicReference, 5000L, "get user properties", new zzhl(this, atomicReference, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgs)this).zzr().zzf().zza("Timed out waiting for get user properties, includeInternal", bl);
            return Collections.emptyList();
        }
        return list;
    }

    @Nullable
    public final String zzah() {
        ((zzgs)this).zzb();
        return this.zzg.get();
    }

    final void zza(@Nullable String string) {
        this.zzg.set(string);
    }

    @WorkerThread
    public final void zzai() {
        ((zzgs)this).zzd();
        ((zzgs)this).zzb();
        this.zzw();
        if (!this.zzy.zzag()) {
            return;
        }
        if (((zzgs)this).zzt().zza(zzaq.zzbg)) {
            zzy zzy2 = ((zzgs)this).zzt();
            zzx zzx2 = ((zzgs)zzy2).zzu();
            Boolean bl = zzy2.zze("google_analytics_deferred_deep_link_enabled");
            if (bl != null && bl != false) {
                ((zzgs)this).zzr().zzw().zza("Deferred Deep Link feature enabled.");
                ((zzgs)this).zzq().zza(new zzhe(this));
            }
        }
        ((zzd)this).zzh().zzae();
        this.zzc = false;
        String string = ((zzgs)this).zzs().zzw();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzgs)this).zzl().zzaa();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.zza("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzhb zzhb2) {
        ((zzgs)this).zzd();
        ((zzgs)this).zzb();
        this.zzw();
        if (zzhb2 != null && zzhb2 != this.zzd) {
            Preconditions.checkState((this.zzd == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzhb2;
    }

    public final void zza(zzha zzha2) {
        ((zzgs)this).zzb();
        this.zzw();
        Preconditions.checkNotNull((Object)zzha2);
        if (!this.zze.add(zzha2)) {
            ((zzgs)this).zzr().zzi().zza("OnEventListener already registered");
        }
    }

    public final void zzb(zzha zzha2) {
        ((zzgs)this).zzb();
        this.zzw();
        Preconditions.checkNotNull((Object)zzha2);
        if (!this.zze.remove(zzha2)) {
            ((zzgs)this).zzr().zzi().zza("OnEventListener had not been registered");
        }
    }

    public final void zza(Bundle bundle) {
        this.zza(bundle, ((zzgs)this).zzm().currentTimeMillis());
    }

    public final void zza(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        ((zzgs)this).zzb();
        Bundle bundle2 = new Bundle(bundle);
        if (!TextUtils.isEmpty((CharSequence)bundle2.getString("app_id"))) {
            ((zzgs)this).zzr().zzi().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle2.remove("app_id");
        this.zzb(bundle2, l);
    }

    public final void zzb(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("app_id"));
        ((zzgs)this).zza();
        this.zzb(new Bundle(bundle), ((zzgs)this).zzm().currentTimeMillis());
    }

    private final void zzb(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = bundle;
        zzgx.zza((Bundle)bundle2, (String)"app_id", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"origin", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"name", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"value", Object.class, null);
        zzgx.zza((Bundle)bundle2, (String)"trigger_event_name", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"trigger_timeout", Long.class, (Object)0L);
        zzgx.zza((Bundle)bundle2, (String)"timed_out_event_name", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"timed_out_event_params", Bundle.class, null);
        zzgx.zza((Bundle)bundle2, (String)"triggered_event_name", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"triggered_event_params", Bundle.class, null);
        zzgx.zza((Bundle)bundle2, (String)"time_to_live", Long.class, (Object)0L);
        zzgx.zza((Bundle)bundle2, (String)"expired_event_name", String.class, null);
        zzgx.zza((Bundle)bundle2, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        String string = bundle.getString("name");
        Object object = bundle.get("value");
        if (((zzgs)this).zzp().zzc(string) != 0) {
            ((zzgs)this).zzr().zzf().zza("Invalid conditional user property name", ((zzgs)this).zzo().zzc(string));
            return;
        }
        if (((zzgs)this).zzp().zzb(string, object) != 0) {
            ((zzgs)this).zzr().zzf().zza("Invalid conditional user property value", ((zzgs)this).zzo().zzc(string), object);
            return;
        }
        Object object2 = ((zzgs)this).zzp().zzc(string, object);
        if (object2 == null) {
            ((zzgs)this).zzr().zzf().zza("Unable to normalize conditional user property value", ((zzgs)this).zzo().zzc(string), object);
            return;
        }
        zzgx.zza((Bundle)bundle, (Object)object2);
        long l2 = bundle.getLong("trigger_timeout");
        if (!(TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name")) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzgs)this).zzr().zzf().zza("Invalid conditional user property timeout", ((zzgs)this).zzo().zzc(string), l2);
            return;
        }
        long l3 = bundle.getLong("time_to_live");
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzgs)this).zzr().zzf().zza("Invalid conditional user property time to live", ((zzgs)this).zzo().zzc(string), l3);
            return;
        }
        ((zzgs)this).zzq().zza(new zzhm(this, bundle));
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        ((zzgs)this).zzb();
        this.zzb(null, string, string2, bundle);
    }

    public final void zza(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgs)this).zza();
        this.zzb(string, string2, string3, bundle);
    }

    private final void zzb(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzgs)this).zzm().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle2 = new Bundle();
        if (string != null) {
            bundle2.putString("app_id", string);
        }
        bundle2.putString("name", string2);
        bundle2.putLong("creation_timestamp", l);
        if (string3 != null) {
            bundle2.putString("expired_event_name", string3);
            bundle2.putBundle("expired_event_params", bundle);
        }
        ((zzgs)this).zzq().zza(new zzhp(this, bundle2));
    }

    @WorkerThread
    private final void zzc(Bundle bundle) {
        zzao zzao2;
        zzao zzao3;
        zzao zzao4;
        ((zzgs)this).zzd();
        this.zzw();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        if (!this.zzy.zzab()) {
            ((zzgs)this).zzr().zzx().zza("Conditional property not set since app measurement is disabled");
            return;
        }
        zzkq zzkq2 = new zzkq(bundle.getString("name"), bundle.getLong("triggered_timestamp"), bundle.get("value"), bundle.getString("origin"));
        try {
            zzao4 = ((zzgs)this).zzp().zza(bundle.getString("app_id"), bundle.getString("triggered_event_name"), bundle.getBundle("triggered_event_params"), bundle.getString("origin"), 0L, true, false);
            zzao3 = ((zzgs)this).zzp().zza(bundle.getString("app_id"), bundle.getString("timed_out_event_name"), bundle.getBundle("timed_out_event_params"), bundle.getString("origin"), 0L, true, false);
            zzao2 = ((zzgs)this).zzp().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkq2, bundle.getLong("creation_timestamp"), false, bundle.getString("trigger_event_name"), zzao3, bundle.getLong("trigger_timeout"), zzao4, bundle.getLong("time_to_live"), zzao2);
        ((zzd)this).zzh().zza(zzw2);
    }

    @WorkerThread
    private final void zzd(Bundle bundle) {
        zzao zzao2;
        ((zzgs)this).zzd();
        this.zzw();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        if (!this.zzy.zzab()) {
            ((zzgs)this).zzr().zzx().zza("Conditional property not cleared since app measurement is disabled");
            return;
        }
        zzkq zzkq2 = new zzkq(bundle.getString("name"), 0L, null, null);
        try {
            zzao2 = ((zzgs)this).zzp().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), bundle.getLong("creation_timestamp"), true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkq2, bundle.getLong("creation_timestamp"), bundle.getBoolean("active"), bundle.getString("trigger_event_name"), null, bundle.getLong("trigger_timeout"), null, bundle.getLong("time_to_live"), zzao2);
        ((zzd)this).zzh().zza(zzw2);
    }

    public final ArrayList<Bundle> zza(String string, String string2) {
        ((zzgs)this).zzb();
        return this.zzb(null, string, string2);
    }

    public final ArrayList<Bundle> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgs)this).zza();
        return this.zzb(string, string2, string3);
    }

    @VisibleForTesting
    private final ArrayList<Bundle> zzb(String string, String string2, String string3) {
        if (((zzgs)this).zzq().zzg()) {
            ((zzgs)this).zzr().zzf().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList<Bundle>(0);
        }
        if (zzx.zza()) {
            ((zzgs)this).zzr().zzf().zza("Cannot get conditional user properties from main thread");
            return new ArrayList<Bundle>(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzq().zza(atomicReference, 5000L, "get conditional user properties", new zzhr(this, atomicReference, string, string2, string3));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgs)this).zzr().zzf().zza("Timed out waiting for get conditional user properties", string);
            return new ArrayList<Bundle>();
        }
        return zzkr.zzb(list);
    }

    public final Map<String, Object> zza(String string, String string2, boolean bl) {
        ((zzgs)this).zzb();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> zza(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgs)this).zza();
        return this.zzb(string, string2, string3, bl);
    }

    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzgs)this).zzq().zzg()) {
            ((zzgs)this).zzr().zzf().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzx.zza()) {
            ((zzgs)this).zzr().zzf().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzq().zza(atomicReference, 5000L, "get user properties", new zzhq(this, atomicReference, string, string2, string3, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgs)this).zzr().zzf().zza("Timed out waiting for handle get user properties, includeInternal", bl);
            return Collections.emptyMap();
        }
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzkq zzkq2 : list) {
            arrayMap.put(zzkq2.zza, zzkq2.zza());
        }
        return arrayMap;
    }

    @Nullable
    public final String zzaj() {
        zzij zzij2 = this.zzy.zzv().zzab();
        if (zzij2 != null) {
            return zzij2.zza;
        }
        return null;
    }

    @Nullable
    public final String zzak() {
        zzij zzij2 = this.zzy.zzv().zzab();
        if (zzij2 != null) {
            return zzij2.zzb;
        }
        return null;
    }

    @Nullable
    public final String zzal() {
        if (this.zzy.zzo() != null) {
            return this.zzy.zzo();
        }
        try {
            String string = "google_app_id";
            Context context = ((zzgs)this).zzn();
            return new StringResourceValueReader(context).getString(string);
        }
        catch (IllegalStateException illegalStateException) {
            this.zzy.zzr().zzf().zza("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzhc zzhc2, boolean bl) {
        zzhc2.zzc(bl);
    }

    static /* synthetic */ void zza(zzhc zzhc2) {
        zzhc2.zzam();
    }

    static /* synthetic */ void zza(zzhc zzhc2, Bundle bundle) {
        zzhc2.zzc(bundle);
    }

    static /* synthetic */ void zzb(zzhc zzhc2, Bundle bundle) {
        zzhc2.zzd(bundle);
    }
}

