/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;

@VisibleForTesting
public final class zzji
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzev zzc;
    final /* synthetic */ zzir zza;

    protected zzji(zzir zzir2) {
        this.zza = zzir2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgs)this.zza).zzd();
        Context context = ((zzgs)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzji zzji2 = this;
        synchronized (zzji2) {
            if (this.zzb) {
                ((zzgs)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzgs)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzir.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzji zzji2 = this;
        synchronized (zzji2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgs)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzem zzem2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzem2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzem ? (zzem)iInterface : new zzeo(iBinder2));
                    ((zzgs)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgs)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgs)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzem2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgs)this.zza).zzn(), (ServiceConnection)zzir.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzem2;
                ((zzgs)this.zza).zzq().zza(new zzjl(this, (zzem)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgs)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzgs)this.zza).zzq().zza(new zzjk(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgs)this.zza).zzd();
        Context context = ((zzgs)this.zza).zzn();
        zzji zzji2 = this;
        synchronized (zzji2) {
            if (this.zzb) {
                ((zzgs)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgs)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzev(context, Looper.getMainLooper(), this, this);
            ((zzgs)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzji zzji2 = this;
        synchronized (zzji2) {
            try {
                zzem zzem2 = (zzem)this.zzc.getService();
                ((zzgs)this.zza).zzq().zza(new zzjn(this, zzem2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgs)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzgs)this.zza).zzq().zza(new zzjm(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzeu zzeu2 = this.zza.zzy.zzd();
        if (zzeu2 != null) {
            zzeu2.zzi().zza("Service connection failed", connectionResult);
        }
        zzji zzji2 = this;
        synchronized (zzji2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgs)this.zza).zzq().zza(new zzjp(this));
    }

    static /* synthetic */ boolean zza(zzji zzji2, boolean bl) {
        zzji2.zzb = false;
        return false;
    }
}

