/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfz;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class zzfs<E>
extends zzfd<E> {
    static final zzfs<Comparable> zzb = new zzfs<Comparable>(zzeq.zza(), zzfi.zza);
    private final transient zzeq<E> zzc;

    zzfs(zzeq<E> zzeq2, Comparator<? super E> comparator) {
        super(comparator);
        this.zzc = zzeq2;
    }

    @Override
    final Object[] zze() {
        return this.zzc.zze();
    }

    @Override
    final int zzf() {
        return this.zzc.zzf();
    }

    @Override
    final int zzg() {
        return this.zzc.zzg();
    }

    @Override
    public final zzfz<E> zzb() {
        return (zzfz)((zzer)this.zzc).iterator();
    }

    @Override
    public final zzfz<E> zzj() {
        return (zzfz)((zzer)this.zzc.zzd()).iterator();
    }

    @Override
    public final int size() {
        return this.zzc.size();
    }

    @Override
    public final boolean contains(@NullableDecl Object object) {
        try {
            if (object != null) {
                Object object2 = object;
                zzfs zzfs2 = this;
                if (Collections.binarySearch(zzfs2.zzc, object2, zzfs2.zza) >= 0) {
                    return true;
                }
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        if (collection instanceof zzfj) {
            collection = ((zzfj)collection).zza();
        }
        if (!zzfw.zza(this.comparator(), collection) || collection.size() <= 1) {
            return super.containsAll(collection);
        }
        zzfz zzfz2 = (zzfz)((zzer)this).iterator();
        Iterator<?> iterator = collection.iterator();
        if (!zzfz2.hasNext()) {
            return false;
        }
        Object obj = iterator.next();
        Object e = zzfz2.next();
        try {
            while (true) {
                int n;
                if ((n = this.zza(e, obj)) < 0) {
                    if (!zzfz2.hasNext()) {
                        return false;
                    }
                    e = zzfz2.next();
                    continue;
                }
                if (n == 0) {
                    if (!iterator.hasNext()) {
                        return true;
                    }
                    obj = iterator.next();
                    continue;
                }
                if (n > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    @Override
    final boolean zzh() {
        return this.zzc.zzh();
    }

    @Override
    final int zzb(Object[] objectArray, int n) {
        return ((zzer)this.zzc).zzb(objectArray, n);
    }

    @Override
    public final boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (zzfw.zza(this.zza, set)) {
            Iterator iterator = set.iterator();
            try {
                zzfz zzfz2 = (zzfz)((zzer)this).iterator();
                while (zzfz2.hasNext()) {
                    Object e = zzfz2.next();
                    Object e2 = iterator.next();
                    if (e2 != null && this.zza(e, e2) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll(set);
    }

    @Override
    public final E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.zzc.get(0);
    }

    @Override
    public final E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.zzc.get(this.size() - 1);
    }

    @Override
    public final E lower(E e) {
        int n = this.zzc(e, false) - 1;
        if (n == -1) {
            return null;
        }
        return this.zzc.get(n);
    }

    @Override
    public final E floor(E e) {
        int n = this.zzc(e, true) - 1;
        if (n == -1) {
            return null;
        }
        return this.zzc.get(n);
    }

    @Override
    public final E ceiling(E e) {
        int n = this.zzd(e, true);
        if (n == this.size()) {
            return null;
        }
        return this.zzc.get(n);
    }

    @Override
    public final E higher(E e) {
        int n = this.zzd(e, false);
        if (n == this.size()) {
            return null;
        }
        return this.zzc.get(n);
    }

    @Override
    final zzfd<E> zza(E e, boolean bl) {
        return this.zza(0, this.zzc(e, bl));
    }

    private final int zzc(E e, boolean bl) {
        int n = Collections.binarySearch(this.zzc, zzdq.zza(e), this.comparator());
        if (n >= 0) {
            if (bl) {
                return n + 1;
            }
            return n;
        }
        return ~n;
    }

    @Override
    final zzfd<E> zza(E e, boolean bl, E e2, boolean bl2) {
        return ((zzfd)this).zzb(e, bl).zza(e2, bl2);
    }

    @Override
    final zzfd<E> zzb(E e, boolean bl) {
        return this.zza(this.zzd(e, bl), this.size());
    }

    private final int zzd(E e, boolean bl) {
        int n = Collections.binarySearch(this.zzc, zzdq.zza(e), this.comparator());
        if (n >= 0) {
            if (bl) {
                return n;
            }
            return n + 1;
        }
        return ~n;
    }

    private final zzfs<E> zza(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        if (n < n2) {
            return new zzfs<E>((zzeq)this.zzc.subList(n, n2), this.zza);
        }
        return zzfs.zza(this.zza);
    }

    @Override
    public final zzeq<E> zzc() {
        return this.zzc;
    }

    @Override
    final zzfd<E> zzi() {
        Comparator comparator = Collections.reverseOrder(this.zza);
        if (this.isEmpty()) {
            return zzfs.zza(comparator);
        }
        return new zzfs<E>(this.zzc.zzd(), comparator);
    }

    @Override
    public final /* synthetic */ Iterator descendingIterator() {
        return ((zzfd)this).zzj();
    }

    @Override
    public final /* synthetic */ Iterator iterator() {
        return ((zzer)this).zzb();
    }
}

