/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgx;
import java.util.List;

public final class zzfq {
    final zzgd zza;

    zzfq(zzgd zzgd2) {
        this.zza = zzgd2;
    }

    @WorkerThread
    protected final void zza(String string) {
        if (string == null || string.isEmpty()) {
            this.zza.zzr().zzj().zza("Install Referrer Reporter was called with invalid app package name");
            return;
        }
        ((zzgx)this.zza.zzq()).zzd();
        if (!this.zza()) {
            this.zza.zzr().zzv().zza("Install Referrer Reporter is not available");
            return;
        }
        zzft zzft2 = new zzft(this, string);
        zzfq zzfq2 = this;
        ((zzgx)zzfq2.zza.zzq()).zzd();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzfq2.zza.zzn().getPackageManager();
        if (packageManager == null) {
            zzfq2.zza.zzr().zzj().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && "com.android.vending".equals(string2) && zzfq2.zza()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzfq2.zza.zzn(), intent2, (ServiceConnection)zzft2, 1);
                        zzfq2.zza.zzr().zzx().zza("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzfq2.zza.zzr().zzf().zza("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzfq2.zza.zzr().zzi().zza("Play Store version 8.3.73 or higher required for Install Referrer");
            }
            return;
        }
        zzfq2.zza.zzr().zzv().zza("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zza() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zza.zzn());
            if (packageManagerWrapper == null) {
                this.zza.zzr().zzx().zza("Failed to get PackageManager for Install Referrer Play Store compatibility check");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zza.zzr().zzx().zza("Failed to retrieve Play Store version for Install Referrer", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zza(String string, zzd zzd2) {
        Bundle bundle;
        ((zzgx)this.zza.zzq()).zzd();
        if (zzd2 == null) {
            this.zza.zzr().zzi().zza("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", string);
        try {
            bundle = zzd2.zza(bundle2);
            if (bundle == null) {
                this.zza.zzr().zzf().zza("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zza.zzr().zzf().zza("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }
}

