/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzx;

public final class zzfv {
    private final zzfu zza;

    public zzfv(zzfu zzfu2) {
        Preconditions.checkNotNull((Object)zzfu2);
        this.zza = zzfu2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void zza(Context context, Intent intent) {
        zzgd zzgd2 = zzgd.zza(context, null, null);
        zzez zzez2 = zzgd2.zzr();
        if (intent == null) {
            zzez2.zzi().zza("Receiver called with null intent");
            return;
        }
        zzx zzx2 = zzgd2.zzu();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzez2.zzx().zza("Device receiver got", string);
        } else {
            zzez2.zzx().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzez2.zzx().zza("Starting wakeful intent.");
            this.zza.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            zzez2.zzi().zza("Install Referrer Broadcasts are deprecated");
        }
    }
}

