/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfw
extends zzgw {
    private zzga zza;
    private zzga zzb;
    private final PriorityBlockingQueue<zzgb<?>> zzc;
    private final BlockingQueue<zzgb<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfw(zzgd zzgd2) {
        super(zzgd2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfy(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfy(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgb zzgb2 = new zzgb(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgx)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzgb2.run();
        } else {
            this.zza(zzgb2);
        }
        return zzgb2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgb zzgb2 = new zzgb(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzgb2.run();
        } else {
            this.zza(zzgb2);
        }
        return zzgb2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgb(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgx)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgx)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgx)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgb<?> zzgb2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzgb2);
            if (this.zza == null) {
                this.zza = new zzga(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzgb zzgb2 = new zzgb(this, runnable, false, "Task exception on network thread");
        zzfw zzfw2 = this;
        Object object = zzfw2.zzg;
        synchronized (object) {
            zzfw2.zzd.add(zzgb2);
            if (zzfw2.zzb == null) {
                zzfw2.zzb = new zzga(zzfw2, "Measurement Network", zzfw2.zzd);
                zzfw2.zzb.setUncaughtExceptionHandler(zzfw2.zzf);
                zzfw2.zzb.start();
            } else {
                zzfw2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfw zzfw2) {
        return zzfw2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfw zzfw2) {
        return zzfw2.zzi;
    }

    static /* synthetic */ Object zzc(zzfw zzfw2) {
        return zzfw2.zzg;
    }

    static /* synthetic */ zzga zzd(zzfw zzfw2) {
        return zzfw2.zza;
    }

    static /* synthetic */ zzga zza(zzfw zzfw2, zzga zzga2) {
        zzfw2.zza = null;
        return null;
    }

    static /* synthetic */ zzga zze(zzfw zzfw2) {
        return zzfw2.zzb;
    }

    static /* synthetic */ zzga zzb(zzfw zzfw2, zzga zzga2) {
        zzfw2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

