/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzmv;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzgd
implements zzgz {
    private static volatile zzgd zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzx zzh;
    private final zzy zzi;
    private final zzfl zzj;
    private final zzez zzk;
    private final zzfw zzl;
    private final zzjw zzm;
    private final zzkw zzn;
    private final zzex zzo;
    private final Clock zzp;
    private final zzin zzq;
    private final zzhh zzr;
    private final zza zzs;
    private final zzie zzt;
    private zzev zzu;
    private zzis zzv;
    private zzai zzw;
    private zzes zzx;
    private zzfq zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private int zzaf;
    private AtomicInteger zzag = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzgd(zzhe zzhe2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhe2);
        Object object2 = zzhe2.zza;
        zzep.zza = this.zzh = new zzx((Context)object2);
        this.zzc = zzhe2.zza;
        this.zzd = zzhe2.zzb;
        this.zze = zzhe2.zzc;
        this.zzf = zzhe2.zzd;
        this.zzg = zzhe2.zzh;
        this.zzac = zzhe2.zze;
        zzae zzae2 = zzhe2.zzg;
        if (zzae2 != null && zzae2.zzg != null) {
            object = zzae2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzae2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzcw.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzhe2.zzi != null ? zzhe2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzy((zzgd)object2);
        object2 = this;
        object = new zzfl((zzgd)object2);
        ((zzgw)object).zzab();
        this.zzj = object;
        object2 = this;
        zzez zzez2 = new zzez((zzgd)object2);
        zzez2.zzab();
        this.zzk = zzez2;
        object2 = this;
        zzkw zzkw2 = new zzkw((zzgd)object2);
        zzkw2.zzab();
        this.zzn = zzkw2;
        object2 = this;
        zzex zzex2 = new zzex((zzgd)object2);
        zzex2.zzab();
        this.zzo = zzex2;
        object2 = this;
        this.zzs = new zza((zzgd)object2);
        object2 = this;
        zzin zzin2 = new zzin((zzgd)object2);
        zzin2.zzx();
        this.zzq = zzin2;
        object2 = this;
        zzhh zzhh2 = new zzhh((zzgd)object2);
        zzhh2.zzx();
        this.zzr = zzhh2;
        object2 = this;
        zzjw zzjw2 = new zzjw((zzgd)object2);
        zzjw2.zzx();
        this.zzm = zzjw2;
        object2 = this;
        zzie zzie2 = new zzie((zzgd)object2);
        zzie2.zzab();
        this.zzt = zzie2;
        object2 = this;
        zzfw zzfw2 = new zzfw((zzgd)object2);
        zzfw2.zzab();
        this.zzl = zzfw2;
        boolean bl = zzhe2.zzg != null && zzhe2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzx zzx2 = ((zzgd)object2).zzh;
        if (((zzgd)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhh zzhh3 = ((zzgd)object2).zzh();
            if (((zzgx)zzhh3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgx)zzhh3).zzn().getApplicationContext();
                if (zzhh3.zza == null) {
                    zzhh3.zza = new zzid(zzhh3, null);
                }
                if (bl3) {
                    zzid zzid2 = zzhh3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzid2);
                    zzid2 = zzhh3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzid2);
                    ((zzgx)zzhh3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzgd)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzgf(this, zzhe2));
    }

    @WorkerThread
    private final void zza(zzhe zzhe2) {
        ((zzgx)this.zzq()).zzd();
        Object object = this;
        zzai zzai2 = new zzai((zzgd)object);
        zzai2.zzab();
        this.zzw = zzai2;
        zzgd zzgd2 = this;
        object = zzhe2;
        zzes zzes2 = new zzes(zzgd2, ((zzhe)object).zzf);
        zzes2.zzx();
        this.zzx = zzes2;
        object = this;
        zzev zzev2 = new zzev((zzgd)object);
        zzev2.zzx();
        this.zzu = zzev2;
        object = this;
        zzis zzis2 = new zzis((zzgd)object);
        zzis2.zzx();
        this.zzv = zzis2;
        this.zzn.zzac();
        this.zzj.zzac();
        object = this;
        this.zzy = new zzfq((zzgd)object);
        this.zzx.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzi.zzf());
        zzx zzx2 = this.zzh;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzx2 = this.zzh;
        String string = zzes2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzfb zzfb2;
            if (this.zzi().zzf(string)) {
                zzfb2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzfb2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzfb2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzaf != this.zzag.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzaf, this.zzag.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza() {
        zzx zzx2;
        ((zzgx)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zza);
            this.zzc().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzaq.zzcq)) {
            zzx2 = this.zzh;
            this.zzh().zzb.zzb();
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzx2 = this.zzh;
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzy()) {
                    if (!zzfv.zza(this.zzc)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkw.zza(this.zzc, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzx2 = this.zzh;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzkw.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzv.zzah();
                    this.zzv.zzaf();
                    this.zzc().zzh.zza(this.zza);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzx2 = this.zzh;
            if (zzmv.zzb() && this.zzi.zza(zzaq.zzbu) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzu.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzu.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzi.zzh()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
                if (zzof.zzb() && this.zzi.zza(zzaq.zzcm)) {
                    this.zzw().zza(this.zzc().zzx.zza());
                }
            }
        }
        this.zzc().zzo.zza(this.zzi.zza(zzaq.zzaz));
    }

    @Override
    public final zzx zzu() {
        return this.zzh;
    }

    public final zzy zzb() {
        return this.zzi;
    }

    public final zzfl zzc() {
        zzgd.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzez zzr() {
        zzgd.zzb(this.zzk);
        return this.zzk;
    }

    public final zzez zzd() {
        if (this.zzk != null && this.zzk.zzz()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzfw zzq() {
        zzgd.zzb(this.zzl);
        return this.zzl;
    }

    public final zzjw zze() {
        zzgd.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfq zzf() {
        return this.zzy;
    }

    final zzfw zzg() {
        return this.zzl;
    }

    public final zzhh zzh() {
        zzgd.zzb(this.zzr);
        return this.zzr;
    }

    public final zzkw zzi() {
        zzgd.zza(this.zzn);
        return this.zzn;
    }

    public final zzex zzj() {
        zzgd.zza(this.zzo);
        return this.zzo;
    }

    public final zzev zzk() {
        zzgd.zzb(this.zzu);
        return this.zzu;
    }

    private final zzie zzai() {
        zzgd.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzn() {
        return this.zzc;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzo() {
        return this.zzd;
    }

    public final String zzp() {
        return this.zze;
    }

    public final String zzs() {
        return this.zzf;
    }

    public final boolean zzt() {
        return this.zzg;
    }

    @Override
    public final Clock zzm() {
        return this.zzp;
    }

    public final zzin zzv() {
        zzgd.zzb(this.zzq);
        return this.zzq;
    }

    public final zzis zzw() {
        zzgd.zzb(this.zzv);
        return this.zzv;
    }

    public final zzai zzx() {
        zzgd.zzb(this.zzw);
        return this.zzw;
    }

    public final zzes zzy() {
        zzgd.zzb(this.zzx);
        return this.zzx;
    }

    public final zza zzz() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgd zza(Context context, zzae zzae2, Long l) {
        if (zzae2 != null && (zzae2.zze == null || zzae2.zzf == null)) {
            zzae2 = new zzae(zzae2.zza, zzae2.zzb, zzae2.zzc, zzae2.zzd, null, null, zzae2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzgd> clazz = zzgd.class;
            synchronized (zzgd.class) {
                if (zzb == null) {
                    zzhe zzhe2 = new zzhe(context, zzae2, l);
                    zzb = new zzgd(zzhe2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzae2 != null && zzae2.zzg != null && zzae2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzae2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgw zzgw2) {
        if (zzgw2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgw2.zzz()) {
            String string = String.valueOf(zzgw2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzv()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgx zzgx2) {
        if (zzgx2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac() == 0;
    }

    @WorkerThread
    public final int zzac() {
        ((zzgx)this.zzq()).zzd();
        if (this.zzi.zzh()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzy zzy2 = this.zzi;
        zzx zzx2 = ((zzgx)zzy2).zzu();
        Boolean bl2 = zzy2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzaq.zzas) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final void zzad() {
        zzx zzx2 = this.zzh;
    }

    final void zzae() {
        zzx zzx2 = this.zzh;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgw zzgw2) {
        ++this.zzaf;
    }

    final void zza(zzg zzg2) {
        ++this.zzaf;
    }

    final void zzaf() {
        this.zzag.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgx)this.zzq()).zzd();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            zzx zzx2 = this.zzh;
            this.zzaa = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzy() || zzfv.zza(this.zzc) && zzkw.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgx)this.zzq()).zzd();
        zzgd.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzi.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgx)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzt.zza() - 1L);
        zzgc zzgc2 = new zzgc(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzie zzie2 = this.zzai();
        ((zzgx)zzie2).zzd();
        zzie2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzgc2);
        ((zzgx)zzie2).zzq().zzb(new zzig(zzie2, string2, uRL2, null, null, zzgc2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzgd zzgd2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzgd2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzgd2.zzc().zzs.zza(true);
        if (byArray2.length == 0) {
            zzgd2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzgd2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkw zzkw2 = zzgd2.zzi();
            ((zzgx)zzkw2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgx)zzkw2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzgd2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzgd2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkw2 = zzgd2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkw2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgx)zzkw2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzgd2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzgd zzgd2, zzhe zzhe2) {
        zzgd2.zza(zzhe2);
    }
}

