/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgx;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class zzal
extends zzgx {
    private long zza;
    private String zzb;
    private Boolean zzc;
    private AccountManager zzd;
    private Boolean zze;
    private long zzf;

    zzal(zzgb zzgb2) {
        super(zzgb2);
    }

    @Override
    protected final boolean zzd() {
        Calendar calendar = Calendar.getInstance();
        this.zza = TimeUnit.MINUTES.convert(calendar.get(15) + calendar.get(16), TimeUnit.MILLISECONDS);
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage().toLowerCase(Locale.ENGLISH);
        String string2 = locale.getCountry().toLowerCase(Locale.ENGLISH);
        this.zzb = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
        return false;
    }

    public final long zze() {
        this.zzaa();
        return this.zza;
    }

    public final String zzf() {
        this.zzaa();
        return this.zzb;
    }

    public final boolean zza(Context context) {
        if (this.zzc == null) {
            this.zzc = false;
            try {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null) {
                    packageManager.getPackageInfo("com.google.android.gms", 128);
                    this.zzc = true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return this.zzc;
    }

    @WorkerThread
    final long zzg() {
        ((zzgu)this).zzc();
        return this.zzf;
    }

    @WorkerThread
    final void zzh() {
        ((zzgu)this).zzc();
        this.zze = null;
        this.zzf = 0L;
    }

    @WorkerThread
    final boolean zzi() {
        ((zzgu)this).zzc();
        long l = ((zzgu)this).zzl().currentTimeMillis();
        if (l - this.zzf > 86400000L) {
            this.zze = null;
        }
        if (this.zze != null) {
            return this.zze;
        }
        if (ContextCompat.checkSelfPermission((Context)((zzgu)this).zzm(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            ((zzgu)this).zzq().zzi().zza("Permission error checking for dasher/unicorn accounts");
            this.zzf = l;
            this.zze = false;
            return false;
        }
        if (this.zzd == null) {
            this.zzd = AccountManager.get((Context)((zzgu)this).zzm());
        }
        try {
            Account[] accountArray = (Account[])this.zzd.getAccountsByTypeAndFeatures("com.google", new String[]{"service_HOSTED"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zze = true;
                this.zzf = l;
                return true;
            }
            accountArray = (Account[])this.zzd.getAccountsByTypeAndFeatures("com.google", new String[]{"service_uca"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zze = true;
                this.zzf = l;
                return true;
            }
        }
        catch (AuthenticatorException | OperationCanceledException | IOException throwable) {
            ((zzgu)this).zzq().zzf().zza("Exception checking account types", throwable);
        }
        this.zzf = l;
        this.zze = false;
        return false;
    }
}

