/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfu
extends zzgx {
    private zzfy zza;
    private zzfy zzb;
    private final PriorityBlockingQueue<zzfz<?>> zzc;
    private final BlockingQueue<zzfz<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfu(zzgb zzgb2) {
        super(zzgb2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfw(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfw(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzd() {
        return false;
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzb() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzf() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfz zzfz2 = new zzfz(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgu)this).zzq().zzh().zza("Callable skipped the worker queue.");
            }
            zzfz2.run();
        } else {
            this.zza(zzfz2);
        }
        return zzfz2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfz zzfz2 = new zzfz(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfz2.run();
        } else {
            this.zza(zzfz2);
        }
        return zzfz2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfz(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgu)this).zzp().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgu)this).zzq().zzh().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgu)this).zzq().zzh().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfz(this, runnable, true, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfz<?> zzfz2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfz2);
            if (this.zza == null) {
                this.zza = new zzfy(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzfz zzfz2 = new zzfz(this, runnable, false, "Task exception on network thread");
        zzfu zzfu2 = this;
        Object object = zzfu2.zzg;
        synchronized (object) {
            zzfu2.zzd.add(zzfz2);
            if (zzfu2.zzb == null) {
                zzfu2.zzb = new zzfy(zzfu2, "Measurement Network", zzfu2.zzd);
                zzfu2.zzb.setUncaughtExceptionHandler(zzfu2.zzf);
                zzfu2.zzb.start();
            } else {
                zzfu2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfu zzfu2) {
        return zzfu2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfu zzfu2) {
        return zzfu2.zzi;
    }

    static /* synthetic */ Object zzc(zzfu zzfu2) {
        return zzfu2.zzg;
    }

    static /* synthetic */ zzfy zzd(zzfu zzfu2) {
        return zzfu2.zza;
    }

    static /* synthetic */ zzfy zza(zzfu zzfu2, zzfy zzfy2) {
        zzfu2.zza = null;
        return null;
    }

    static /* synthetic */ zzfy zze(zzfu zzfu2) {
        return zzfu2.zzb;
    }

    static /* synthetic */ zzfy zzb(zzfu zzfu2, zzfy zzfy2) {
        zzfu2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzg() {
        return zzj;
    }
}

