/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzmb;
import com.google.android.gms.internal.measurement.zzmn;
import com.google.android.gms.internal.measurement.zznr;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzgb
implements zzgw {
    private static volatile zzgb zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzx zzh;
    private final zzy zzi;
    private final zzfj zzj;
    private final zzex zzk;
    private final zzfu zzl;
    private final zzkb zzm;
    private final zzkx zzn;
    private final zzev zzo;
    private final Clock zzp;
    private final zzim zzq;
    private final zzhe zzr;
    private final zza zzs;
    private final zzih zzt;
    private zzet zzu;
    private zziv zzv;
    private zzal zzw;
    private zzeq zzx;
    private zzfo zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private AtomicInteger zzah = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzgb(zzhf zzhf2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhf2);
        Object object2 = zzhf2.zza;
        zzen.zza = this.zzh = new zzx((Context)object2);
        this.zzc = zzhf2.zza;
        this.zzd = zzhf2.zzb;
        this.zze = zzhf2.zzc;
        this.zzf = zzhf2.zzd;
        this.zzg = zzhf2.zzh;
        this.zzac = zzhf2.zze;
        this.zzaf = true;
        zzae zzae2 = zzhf2.zzg;
        if (zzae2 != null && zzae2.zzg != null) {
            object = zzae2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzae2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzdc.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzhf2.zzi != null ? zzhf2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzy((zzgb)object2);
        object2 = this;
        object = new zzfj((zzgb)object2);
        ((zzgx)object).zzab();
        this.zzj = object;
        object2 = this;
        zzex zzex2 = new zzex((zzgb)object2);
        zzex2.zzab();
        this.zzk = zzex2;
        object2 = this;
        zzkx zzkx2 = new zzkx((zzgb)object2);
        zzkx2.zzab();
        this.zzn = zzkx2;
        object2 = this;
        zzev zzev2 = new zzev((zzgb)object2);
        zzev2.zzab();
        this.zzo = zzev2;
        object2 = this;
        this.zzs = new zza((zzgb)object2);
        object2 = this;
        zzim zzim2 = new zzim((zzgb)object2);
        zzim2.zzw();
        this.zzq = zzim2;
        object2 = this;
        zzhe zzhe2 = new zzhe((zzgb)object2);
        zzhe2.zzw();
        this.zzr = zzhe2;
        object2 = this;
        zzkb zzkb2 = new zzkb((zzgb)object2);
        zzkb2.zzw();
        this.zzm = zzkb2;
        object2 = this;
        zzih zzih2 = new zzih((zzgb)object2);
        zzih2.zzab();
        this.zzt = zzih2;
        object2 = this;
        zzfu zzfu2 = new zzfu((zzgb)object2);
        zzfu2.zzab();
        this.zzl = zzfu2;
        boolean bl = zzhf2.zzg != null && zzhf2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzgb)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhe zzhe3 = ((zzgb)object2).zzg();
            if (((zzgu)zzhe3).zzm().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgu)zzhe3).zzm().getApplicationContext();
                if (zzhe3.zza == null) {
                    zzhe3.zza = new zzic(zzhe3, null);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhe3.zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhe3.zza);
                    ((zzgu)zzhe3).zzq().zzw().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzgb)object2).zzq().zzh().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzgd(this, zzhf2));
    }

    @WorkerThread
    private final void zza(zzhf zzhf2) {
        ((zzgu)this.zzp()).zzc();
        Object object = this;
        zzal zzal2 = new zzal((zzgb)object);
        zzal2.zzab();
        this.zzw = zzal2;
        zzgb zzgb2 = this;
        object = zzhf2;
        zzeq zzeq2 = new zzeq(zzgb2, ((zzhf)object).zzf);
        zzeq2.zzw();
        this.zzx = zzeq2;
        object = this;
        zzet zzet2 = new zzet((zzgb)object);
        zzet2.zzw();
        this.zzu = zzet2;
        object = this;
        zziv zziv2 = new zziv((zzgb)object);
        zziv2.zzw();
        this.zzv = zziv2;
        this.zzn.zzac();
        this.zzj.zzac();
        object = this;
        this.zzy = new zzfo((zzgb)object);
        this.zzx.zzx();
        this.zzq().zzu().zza("App measurement initialized, version", 31049L);
        this.zzq().zzu().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzeq2.zzaa();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzez zzez2;
            if (this.zzh().zze(string)) {
                zzez2 = this.zzq().zzu();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzez2 = this.zzq().zzu();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzez2.zza(string2);
        }
        this.zzq().zzv().zza("Debug-level message logging enabled");
        if (this.zzag != this.zzah.get()) {
            this.zzq().zze().zza("Not all components initialized", this.zzag, this.zzah.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza(zzae zzae2) {
        ((zzgu)this.zzp()).zzc();
        if (zzmb.zzb() && this.zzi.zza(zzat.zzco)) {
            zzad zzad2;
            zzad zzad3 = this.zzb().zzw();
            if (zzae2 != null && zzae2.zzg != null && this.zzb().zza(30) && !(zzad2 = com.google.android.gms.measurement.internal.zzad.zzb(zzae2.zzg)).equals(com.google.android.gms.measurement.internal.zzad.zza)) {
                zzad3 = zzad2;
                this.zzg().zza(zzad3, 30, this.zza);
            }
            this.zzg().zza(zzad3);
        }
        if (this.zzb().zzc.zza() == 0L) {
            this.zzb().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzb().zzh.zza()) == 0L) {
            this.zzq().zzw().zza("Persisting first open", this.zza);
            this.zzb().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzat.zzck)) {
            this.zzg().zzb.zzb();
        }
        if (!this.zzaf()) {
            if (this.zzaa()) {
                if (!this.zzh().zzc("android.permission.INTERNET")) {
                    this.zzq().zze().zza("App is missing INTERNET permission");
                }
                if (!this.zzh().zzc("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzq().zze().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzw()) {
                    if (!zzft.zza(this.zzc)) {
                        this.zzq().zze().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkx.zza(this.zzc, false)) {
                        this.zzq().zze().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzq().zze().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac())) {
                this.zzh();
                if (zzkx.zza(this.zzx().zzab(), this.zzb().zzg(), this.zzx().zzac(), this.zzb().zzh())) {
                    this.zzq().zzu().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzb().zzj();
                    this.zzj().zzaa();
                    this.zzv.zzag();
                    this.zzv.zzae();
                    this.zzb().zzh.zza(this.zza);
                    this.zzb().zzj.zza(null);
                }
                this.zzb().zzb(this.zzx().zzab());
                this.zzb().zzc(this.zzx().zzac());
            }
            if (zzmb.zzb() && this.zzi.zza(zzat.zzco) && !this.zzb().zzw().zze()) {
                this.zzb().zzj.zza(null);
            }
            this.zzg().zza(this.zzb().zzj.zza());
            if (zzmn.zzb() && this.zzi.zza(zzat.zzbq) && !this.zzh().zzj() && !TextUtils.isEmpty((CharSequence)this.zzb().zzu.zza())) {
                this.zzq().zzh().zza("Remote config removed with active feature rollouts");
                this.zzb().zzu.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac())) {
                boolean bl = this.zzaa();
                if (!this.zzb().zzy() && !this.zzi.zzf()) {
                    this.zzb().zzb(!bl);
                }
                if (bl) {
                    this.zzg().zzah();
                }
                this.zzd().zza.zza();
                this.zzv().zza(new AtomicReference<String>());
                if (zznr.zzb() && this.zzi.zza(zzat.zzcg)) {
                    this.zzv().zza(this.zzb().zzx.zza());
                }
            }
        }
        this.zzb().zzo.zza(this.zzi.zza(zzat.zzay));
    }

    @Override
    public final zzx zzt() {
        return this.zzh;
    }

    public final zzy zza() {
        return this.zzi;
    }

    public final zzfj zzb() {
        zzgb.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzex zzq() {
        zzgb.zzb(this.zzk);
        return this.zzk;
    }

    public final zzex zzc() {
        if (this.zzk != null && this.zzk.zzz()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzfu zzp() {
        zzgb.zzb(this.zzl);
        return this.zzl;
    }

    public final zzkb zzd() {
        zzgb.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfo zze() {
        return this.zzy;
    }

    final zzfu zzf() {
        return this.zzl;
    }

    public final zzhe zzg() {
        zzgb.zzb(this.zzr);
        return this.zzr;
    }

    public final zzkx zzh() {
        zzgb.zza(this.zzn);
        return this.zzn;
    }

    public final zzev zzi() {
        zzgb.zza(this.zzo);
        return this.zzo;
    }

    public final zzet zzj() {
        zzgb.zzb(this.zzu);
        return this.zzu;
    }

    private final zzih zzah() {
        zzgb.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzm() {
        return this.zzc;
    }

    public final boolean zzk() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzn() {
        return this.zzd;
    }

    public final String zzo() {
        return this.zze;
    }

    public final String zzr() {
        return this.zzf;
    }

    public final boolean zzs() {
        return this.zzg;
    }

    @Override
    public final Clock zzl() {
        return this.zzp;
    }

    public final zzim zzu() {
        zzgb.zzb(this.zzq);
        return this.zzq;
    }

    public final zziv zzv() {
        zzgb.zzb(this.zzv);
        return this.zzv;
    }

    public final zzal zzw() {
        zzgb.zzb(this.zzw);
        return this.zzw;
    }

    public final zzeq zzx() {
        zzgb.zzb(this.zzx);
        return this.zzx;
    }

    public final zza zzy() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgb zza(Context context, zzae zzae2, Long l) {
        if (zzae2 != null && (zzae2.zze == null || zzae2.zzf == null)) {
            zzae2 = new zzae(zzae2.zza, zzae2.zzb, zzae2.zzc, zzae2.zzd, null, null, zzae2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzgb> clazz = zzgb.class;
            synchronized (zzgb.class) {
                if (zzb == null) {
                    zzhf zzhf2 = new zzhf(context, zzae2, l);
                    zzb = new zzgb(zzhf2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzae2 != null && zzae2.zzg != null && zzae2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzae2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgx zzgx2) {
        if (zzgx2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgx2.zzz()) {
            String string = String.valueOf(zzgx2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzu()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgu zzgu2) {
        if (zzgu2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzz() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab() == 0;
    }

    @WorkerThread
    public final int zzab() {
        ((zzgu)this.zzp()).zzc();
        if (this.zzi.zzf()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (zzmb.zzb() && this.zzi.zza(zzat.zzco) && !this.zzac()) {
            return 8;
        }
        Boolean bl = this.zzb().zzu();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzy zzy2 = this.zzi;
        Boolean bl2 = zzy2.zzf("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzat.zzas) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzgu)this.zzp()).zzc();
        this.zzaf = bl;
    }

    @WorkerThread
    public final boolean zzac() {
        ((zzgu)this.zzp()).zzc();
        return this.zzaf;
    }

    final void zzad() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgx zzgx2) {
        ++this.zzag;
    }

    final void zza(zzg zzg2) {
        ++this.zzag;
    }

    final void zzae() {
        this.zzah.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgu)this.zzp()).zzc();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzh().zzc("android.permission.INTERNET") && this.zzh().zzc("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzw() || zzft.zza(this.zzc) && zzkx.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzh().zza(this.zzx().zzab(), this.zzx().zzac(), this.zzx().zzad()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzag() {
        ((zzgu)this.zzp()).zzc();
        zzgb.zzb(this.zzah());
        String string = this.zzx().zzaa();
        Pair<String, Boolean> pair = this.zzb().zza(string);
        if (!this.zzi.zzg().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzq().zzv().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzah().zzf()) {
            this.zzq().zzh().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        zzkx zzkx2 = this.zzh();
        this.zzx();
        URL uRL = zzkx2.zza(31049L, string, (String)pair.first, this.zzb().zzt.zza() - 1L);
        zzga zzga2 = new zzga(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzih zzih2 = this.zzah();
        ((zzgu)zzih2).zzc();
        zzih2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzga2);
        ((zzgu)zzih2).zzp().zzc(new zzij(zzih2, string2, uRL2, null, null, zzga2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzgb zzgb2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzgb2.zzq().zzh().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzgb2.zzb().zzs.zza(true);
        if (byArray2.length == 0) {
            zzgb2.zzq().zzv().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzgb2.zzq().zzv().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkx zzkx2 = zzgb2.zzh();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgu)zzkx2).zzm().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzgb2.zzq().zzh().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzgb2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkx2 = zzgb2.zzh();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkx2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgu)zzkx2).zzm().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzgb2.zzq().zze().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzgb zzgb2, zzhf zzhf2) {
        zzgb2.zza(zzhf2);
    }
}

