/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzmb;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zziv
extends zzg {
    private final zzjp zza;
    private zzep zzb;
    private volatile Boolean zzc;
    private final zzaj zzd;
    private final zzki zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaj zzg;

    protected zziv(zzgb zzgb2) {
        super(zzgb2);
        this.zze = new zzki(zzgb2.zzl());
        this.zza = new zzjp(this);
        this.zzd = new zziu(this, zzgb2);
        this.zzg = new zzje(this, zzgb2);
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    @WorkerThread
    public final boolean zzaa() {
        ((zzgu)this).zzc();
        this.zzv();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzab() {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(true);
        this.zza(new zzjg(this, zzn2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        if (zzmb.zzb() && ((zzgu)this).zzs().zza(zzat.zzco)) {
            ((zzgu)this).zzc();
            this.zzv();
            if (bl) {
                ((zzd)this).zzi().zzaa();
            }
            if (this.zzai()) {
                zzn zzn2 = this.zzb(false);
                this.zza(new zzjj(this, zzn2));
            }
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzep zzep2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgu)this).zzc();
        this.zzv();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzd)this).zzi().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzar) {
                    try {
                        zzep2.zza((zzar)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgu)this).zzq().zze().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkw) {
                    try {
                        zzep2.zza((zzkw)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgu)this).zzq().zze().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzw) {
                    try {
                        zzep2.zza((zzw)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgu)this).zzq().zze().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgu)this).zzq().zze().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzar zzar2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzar2));
        ((zzgu)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzar2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzji(this, true, bl, zzar2, zzn2, string));
    }

    @WorkerThread
    protected final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)((Object)zzw2));
        ((zzgu)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzw2);
        zzw zzw3 = new zzw(zzw2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzjl(this, true, bl, zzw3, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzw>> atomicReference, String string, String string2, String string3) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjk(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjn(this, string, string2, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkw>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjm(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2, boolean bl) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzix(this, string, string2, bl, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(zzkw zzkw2) {
        ((zzgu)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzkw2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zziw(this, bl, zzkw2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkw>> atomicReference, boolean bl) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zziz(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zzac() {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        ((zzd)this).zzi().zzaa();
        this.zza(new zziy(this, zzn2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjb(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzja(this, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(true);
        ((zzd)this).zzi().zzab();
        this.zza(new zzjd(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzin zzin2) {
        ((zzgu)this).zzc();
        this.zzv();
        this.zza(new zzjc(this, zzin2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzgu)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjf(this, bundle, zzn2));
    }

    @WorkerThread
    private final void zzaj() {
        ((zzgu)this).zzc();
        this.zze.zza();
        this.zzd.zza((Long)zzat.zzai.zza(null));
    }

    @WorkerThread
    final void zzae() {
        ((zzgu)this).zzc();
        this.zzv();
        if (this.zzaa()) {
            return;
        }
        if (this.zzak()) {
            this.zza.zzb();
            return;
        }
        if (!((zzgu)this).zzs().zzw()) {
            Intent intent;
            zziv zziv2 = this;
            PackageManager packageManager = ((zzgu)zziv2).zzm().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzgu)zziv2).zzm(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzgu)this).zzm(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzgu)this).zzq().zze().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzaf() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzak() {
        ((zzgu)this).zzc();
        this.zzv();
        if (this.zzc == null) {
            boolean bl;
            zziv zziv2 = this;
            ((zzgu)zziv2).zzc();
            zziv2.zzv();
            Boolean bl2 = ((zzgu)zziv2).zzr().zzi();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzd)zziv2).zzf().zzaf() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgu)zziv2).zzq().zzw().zza("Checking service availability");
                    int n = ((zzgu)zziv2).zzo().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgu)zziv2).zzq().zzw().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgu)zziv2).zzq().zzw().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgu)zziv2).zzq().zzh().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgu)zziv2).zzq().zzv().zza("Service container out of date");
                            if (((zzgu)zziv2).zzo().zzi() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgu)zziv2).zzq().zzh().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgu)zziv2).zzq().zzh().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgu)zziv2).zzq().zzh().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgu)zziv2).zzs().zzw()) {
                    ((zzgu)zziv2).zzq().zze().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgu)zziv2).zzr().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzep zzep2) {
        ((zzgu)this).zzc();
        Preconditions.checkNotNull((Object)zzep2);
        this.zzb = zzep2;
        this.zzaj();
        this.zzam();
    }

    @WorkerThread
    public final void zzag() {
        ((zzgu)this).zzc();
        this.zzv();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgu)this).zzm(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzgu)this).zzc();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzgu)this).zzq().zzw().zza("Disconnected from device MeasurementService", componentName);
            zziv zziv2 = this;
            ((zzgu)zziv2).zzc();
            zziv2.zzae();
        }
    }

    @WorkerThread
    private final void zzal() {
        ((zzgu)this).zzc();
        if (!this.zzaa()) {
            return;
        }
        ((zzgu)this).zzq().zzw().zza("Inactivity, disconnecting from the service");
        this.zzag();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzgu)this).zzc();
        if (this.zzaa()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzgu)this).zzq().zze().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzae();
    }

    @WorkerThread
    private final void zzam() {
        ((zzgu)this).zzc();
        ((zzgu)this).zzq().zzw().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgu)this).zzq().zze().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzn zzb(boolean bl) {
        return ((zzd)this).zzf().zza(bl ? ((zzgu)this).zzq().zzx() : null);
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2, zzar zzar2, String string) {
        ((zzgu)this).zzc();
        this.zzv();
        if (((zzgu)this).zzo().zza(12451000) != 0) {
            ((zzgu)this).zzq().zzh().zza("Not bundling data. Service unavailable or out of date");
            ((zzgu)this).zzo().zza(zzw2, new byte[0]);
            return;
        }
        this.zza(new zzjh(this, zzar2, string, zzw2));
    }

    @WorkerThread
    final boolean zzah() {
        ((zzgu)this).zzc();
        this.zzv();
        if (!this.zzak()) {
            return true;
        }
        return ((zzgu)this).zzo().zzi() >= 200900;
    }

    @WorkerThread
    final boolean zzai() {
        ((zzgu)this).zzc();
        this.zzv();
        if (!((zzgu)this).zzs().zza(zzat.zzcp)) {
            return false;
        }
        if (!this.zzak()) {
            return true;
        }
        return ((zzgu)this).zzo().zzi() >= (Integer)zzat.zzcq.zza(null);
    }

    static /* synthetic */ zzjp zza(zziv zziv2) {
        return zziv2.zza;
    }

    static /* synthetic */ void zza(zziv zziv2, ComponentName componentName) {
        zziv2.zza(componentName);
    }

    static /* synthetic */ zzep zza(zziv zziv2, zzep zzep2) {
        zziv2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zziv zziv2) {
        zziv2.zzam();
    }

    static /* synthetic */ void zzc(zziv zziv2) {
        zziv2.zzal();
    }

    static /* synthetic */ zzep zzd(zziv zziv2) {
        return zziv2.zzb;
    }

    static /* synthetic */ void zze(zziv zziv2) {
        zziv2.zzaj();
    }
}

